// tstUSB2Peri1_2.c

//-----------------------------------------------------------------------
//
//	Programme de test de la bibliothque d'interface USB2Peri1
//	---------------------------------------------------------------------
//
//	A utiliser avec :
//	Programme Usb2Peri1V1.x du PIC 18F4550 (test avec 1.0)
//
//	Le programme affiche un message sur un afficheur graphique/clavier 
//	122*32 pixels connect  l'interface
//
//	(C) 2009 CHAMOUARD
//
//  (Libre de droits pour utilisation non commerciale 
//	et  vos propres risques)
//
//-----------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "..\libelec\USB2Peri1Lib.h"

#define Add1CmdWrite	0
#define Add1CmdRead		2
#define Add1DatWrite	1
#define	Add1DatRead		3
#define Add2CmdWrite	4
#define Add2CmdRead		6
#define Add2DatWrite	5
#define	Add2DatRead		7
#define	AddClavRead		4

void LcdWriteCmd(int Cmd, int Numero)
{
	if(Numero==0)
	{
		while((per1_read(Add1CmdRead)&0x80));
		per1_write(Add1CmdWrite, Cmd);
	}
	else
	{
		while((per1_read(Add2CmdRead)&0x80));
		per1_write(Add2CmdWrite, Cmd);
	}
}

void LcdWriteDat(int Dat, int Numero)
{
	if(Numero==0)
	{
		while((per1_read(Add1CmdRead)&0x80));
		per1_write(Add1DatWrite, Dat);
	}
	else
	{
		while((per1_read(Add2CmdRead)&0x80));
		per1_write(Add2DatWrite, Dat);
	}
}

int LcdReadDat(int Numero)
{
	if(Numero==0)
	{
		while((per1_read(Add1CmdRead)&0x80));
		return(per1_read(Add1DatRead));
	}
	else
	{
		while((per1_read(Add2CmdRead)&0x80));
		return(per1_read(Add2DatRead));
	}
}

void LcdClear()
{
	int i, j;
	for(i=0; i<4; ++i)
	{
		LcdWriteCmd(0xB8+i, 0);
		LcdWriteCmd(0xB8+i, 1);
		LcdWriteCmd(0x00, 0);
		LcdWriteCmd(0x00, 1);
		for(j=0; j<61; ++j)
		{
			LcdWriteDat(0x00, 0);
			LcdWriteDat(0x00, 1);
		}
	}
}

void LcdSetPixel(int x, int y)
{
	int aff, ligne, col, data;
	
	if(x>121)x=121;
	if(y>31)y=31;
	
	ligne=y/8;
	y=y%8;

	aff=x/61;
	col=x%61;

	LcdWriteCmd(0xB8+ligne, aff);
	LcdWriteCmd(col, aff);
	data=LcdReadDat(aff);
	data=LcdReadDat(aff);
	LcdWriteCmd(col, aff);
	LcdWriteDat(data | (0x01<<y), aff);
}

int main()
{
	int i,res;

	res=per1_init();
	if(res!=0)
	{
		printf("Initialisation incorrecte de la carte USB2Peri1, Erreur=%d\n",res);
		return(0);
	}
	printf("Initialisation correcte de l'interface USB2Peri1\n");
	
	// Initialisation de l'afficheur
	LcdWriteCmd(0xE2, 0);	// Reset
	LcdWriteCmd(0xAF, 0);
	LcdWriteCmd(0xE2, 1);	// Display ON
	LcdWriteCmd(0xAF, 1);
	LcdWriteCmd(0xA9, 0);	// Duty cycle 1/32
	LcdWriteCmd(0xA9, 1);
	LcdWriteCmd(0xA0, 0);	// Ecriture vers la droite
	LcdWriteCmd(0xA0, 0);
	LcdClear();				// Effacement de l'cran

	// Trace du cadre
	for(i=0; i<122; ++i)
	{
		LcdSetPixel(i, 0);
		LcdSetPixel(i, 1);
		LcdSetPixel(i, 30);
		LcdSetPixel(i, 31);
	}
	for(i=0; i<32; ++i)
	{
		LcdSetPixel(0, i);
		LcdSetPixel(1, i);
		LcdSetPixel(120, i);
		LcdSetPixel(121, i);
	}

	// Trace du +
	for(i=0; i<17; ++i)
	{
		LcdSetPixel(i+53, 15);
		LcdSetPixel(i+53, 16);
		LcdSetPixel(i+53, 17);
		LcdSetPixel(60, i+8);
		LcdSetPixel(61, i+8);
		LcdSetPixel(62, i+8);
	}

	// Trace des E
	for(i=0; i<17; ++i)
	{
		LcdSetPixel(i+23, 15);
		LcdSetPixel(i+23, 16);
		LcdSetPixel(i+23, 17);
		LcdSetPixel(i+25, 8);
		LcdSetPixel(i+25, 9);
		LcdSetPixel(i+25, 10);
		LcdSetPixel(i+21, 22);
		LcdSetPixel(i+21, 23);
		LcdSetPixel(i+21, 24);
		LcdSetPixel(i+81, 15);
		LcdSetPixel(i+81, 16);
		LcdSetPixel(i+81, 17);
		LcdSetPixel(i+83, 8);
		LcdSetPixel(i+83, 9);
		LcdSetPixel(i+83, 10);
		LcdSetPixel(i+79, 22);
		LcdSetPixel(i+79, 23);
		LcdSetPixel(i+79, 24);
	}
	for(i=0; i<4; ++i)
	{
		LcdSetPixel(24, i+11);
		LcdSetPixel(25, i+11);
		LcdSetPixel(26, i+11);
		LcdSetPixel(22, i+18);
		LcdSetPixel(23, i+18);
		LcdSetPixel(24, i+18);
		LcdSetPixel(82, i+11);
		LcdSetPixel(83, i+11);
		LcdSetPixel(84, i+11);
		LcdSetPixel(80, i+18);
		LcdSetPixel(81, i+18);
		LcdSetPixel(82, i+18);
	}

	while(!kbhit());
	
	return(0);
}