
########## Tcl recorder starts at 09/08/09 21:05:07 ##########

set version "1.2"
set proj_dir "D:/E/FPGA/tst1016_002"
cd $proj_dir

# Get directory paths
set pver $version
regsub -all {\.} $pver {_} pver
set lscfile "lsc_"
append lscfile $pver ".ini"
set lsvini_dir [lindex [array get env LSC_INI_PATH] 1]
set lsvini_path [file join $lsvini_dir $lscfile]
if {[catch {set fid [open $lsvini_path]} msg]} {
	 puts "File Open Error: $lsvini_path"
	 return false
} else {set data [read $fid]; close $fid }
foreach line [split $data '\n'] { 
	set lline [string tolower $line]
	set lline [string trim $lline]
	if {[string compare $lline "\[paths\]"] == 0} { set path 1; continue}
	if {$path && [regexp {^\[} $lline]} {set path 0; break}
	if {$path && [regexp {^bin} $lline]} {set cpld_bin $line; continue}
	if {$path && [regexp {^fpgapath} $lline]} {set fpga_dir $line; continue}
	if {$path && [regexp {^fpgabinpath} $lline]} {set fpga_bin $line}}

set cpld_bin [string range $cpld_bin [expr [string first "=" $cpld_bin]+1] end]
regsub -all "\"" $cpld_bin "" cpld_bin
set cpld_bin [file join $cpld_bin]
set install_dir [string range $cpld_bin 0 [expr [string first "ispcpld" $cpld_bin]-2]]
regsub -all "\"" $install_dir "" install_dir
set install_dir [file join $install_dir]
set fpga_dir [string range $fpga_dir [expr [string first "=" $fpga_dir]+1] end]
regsub -all "\"" $fpga_dir "" fpga_dir
set fpga_dir [file join $fpga_dir]
set fpga_bin [string range $fpga_bin [expr [string first "=" $fpga_bin]+1] end]
regsub -all "\"" $fpga_bin "" fpga_bin
set fpga_bin [file join $fpga_bin]

if {[string match "*$fpga_bin;*" $env(PATH)] == 0 } {
   set env(PATH) "$fpga_bin;$env(PATH)" }

if {[string match "*$cpld_bin;*" $env(PATH)] == 0 } {
   set env(PATH) "$cpld_bin;$env(PATH)" }

lappend auto_path [file join $install_dir "ispcpld" "tcltk" "lib" "ispwidget" "runproc"]
package require runcmd

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:05:07 ###########


########## Tcl recorder starts at 09/08/09 21:05:17 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\"  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:05:17 ###########


########## Tcl recorder starts at 09/08/09 21:12:33 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:12:33 ###########


########## Tcl recorder starts at 09/08/09 21:12:38 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\"  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:12:38 ###########


########## Tcl recorder starts at 09/08/09 21:13:58 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:13:58 ###########


########## Tcl recorder starts at 09/08/09 21:17:50 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:17:50 ###########


########## Tcl recorder starts at 09/08/09 21:17:55 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:17:55 ###########


########## Tcl recorder starts at 09/08/09 21:18:29 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:18:29 ###########


########## Tcl recorder starts at 09/08/09 21:18:31 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:18:31 ###########


########## Tcl recorder starts at 09/08/09 21:18:38 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:18:38 ###########


########## Tcl recorder starts at 09/08/09 21:19:46 ##########

# Commands to make the Process: 
# Compiled Equations
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.eq0\" -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:19:46 ###########


########## Tcl recorder starts at 09/08/09 21:20:33 ##########

# Commands to make the Process: 
# Fit Design
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:20:33 ###########


########## Tcl recorder starts at 09/08/09 21:24:37 ##########

# Commands to make the Process: 
# Functional Simulation
# - none -
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:24:37 ###########


########## Tcl recorder starts at 09/08/09 21:25:18 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:25:18 ###########


########## Tcl recorder starts at 09/08/09 21:25:28 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:25:28 ###########


########## Tcl recorder starts at 09/08/09 21:25:32 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:25:32 ###########


########## Tcl recorder starts at 09/08/09 21:33:50 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:33:50 ###########


########## Tcl recorder starts at 09/08/09 21:34:13 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:34:13 ###########


########## Tcl recorder starts at 09/08/09 21:34:17 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:34:17 ###########


########## Tcl recorder starts at 09/08/09 21:35:01 ##########

# Commands to make the Process: 
# Compiler Listing
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -list -sim tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:35:01 ###########


########## Tcl recorder starts at 09/08/09 21:35:26 ##########

# Commands to make the Process: 
# ABEL Test Vector Template
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.abt\" -testfix -template \"$install_dir/ispcpld/plsi/abel/plsiabt.tft\" -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:35:26 ###########


########## Tcl recorder starts at 09/08/09 21:35:39 ##########

# Commands to make the Process: 
# Functional Simulation
# - none -
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:35:39 ###########


########## Tcl recorder starts at 09/08/09 21:41:05 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:41:05 ###########


########## Tcl recorder starts at 09/08/09 21:41:14 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:41:14 ###########


########## Tcl recorder starts at 09/08/09 21:41:20 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:41:20 ###########


########## Tcl recorder starts at 09/08/09 21:43:36 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:43:36 ###########


########## Tcl recorder starts at 09/08/09 21:43:39 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:43:39 ###########


########## Tcl recorder starts at 09/08/09 21:47:48 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:47:48 ###########


########## Tcl recorder starts at 09/08/09 21:47:56 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:47:56 ###########


########## Tcl recorder starts at 09/08/09 21:47:59 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:47:59 ###########


########## Tcl recorder starts at 09/08/09 21:51:14 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:51:14 ###########


########## Tcl recorder starts at 09/08/09 21:51:21 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:51:21 ###########


########## Tcl recorder starts at 09/08/09 21:52:48 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:52:48 ###########


########## Tcl recorder starts at 09/08/09 21:52:55 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 21:52:55 ###########


########## Tcl recorder starts at 09/08/09 22:07:56 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:07:56 ###########


########## Tcl recorder starts at 09/08/09 22:08:01 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:08:01 ###########


########## Tcl recorder starts at 09/08/09 22:08:14 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:08:14 ###########


########## Tcl recorder starts at 09/08/09 22:11:39 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:11:39 ###########


########## Tcl recorder starts at 09/08/09 22:11:42 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:11:42 ###########


########## Tcl recorder starts at 09/08/09 22:11:46 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:11:46 ###########


########## Tcl recorder starts at 09/08/09 22:12:45 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:12:45 ###########


########## Tcl recorder starts at 09/08/09 22:12:55 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:12:55 ###########


########## Tcl recorder starts at 09/08/09 22:15:05 ##########

# Commands to make the Process: 
# Check Syntax
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -syn -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:05 ###########


########## Tcl recorder starts at 09/08/09 22:15:07 ##########

# Commands to make the Process: 
# Compiler Listing
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -syn -list -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:07 ###########


########## Tcl recorder starts at 09/08/09 22:15:08 ##########

# Commands to make the Process: 
# Compiled Equations
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.eq0\" -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:08 ###########


########## Tcl recorder starts at 09/08/09 22:15:11 ##########

# Commands to make the Process: 
# Verilog Test Fixture Declarations
if [runCmd "\"$cpld_bin/blif2eqn\" register.bl0 -o register.tfi -testfix -template \"$install_dir/ispcpld/plsi/verilog/plsitfi.tft\" -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:11 ###########


########## Tcl recorder starts at 09/08/09 22:15:13 ##########

# Commands to make the Process: 
# Verilog Test Fixture Template
if [runCmd "\"$cpld_bin/blif2eqn\" register.bl0 -o register.tft -testfix -template \"$install_dir/ispcpld/plsi/verilog/plsitft.tft\" -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:13 ###########


########## Tcl recorder starts at 09/08/09 22:15:14 ##########

# Commands to make the Process: 
# VHDL Test Bench Template
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -testfixture -template \"$install_dir/ispcpld/generic/vhdl/testbnch.tft\" -bus rebuild -o \"register.vht\" -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:14 ###########


########## Tcl recorder starts at 09/08/09 22:15:16 ##########

# Commands to make the Process: 
# Reduce Logic
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:16 ###########


########## Tcl recorder starts at 09/08/09 22:15:18 ##########

# Commands to make the Process: 
# Reduced Equations
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl1\" -o \"register.eq1\" -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:15:18 ###########


########## Tcl recorder starts at 09/08/09 22:50:55 ##########

# Commands to make the Process: 
# Fitter Report
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:50:55 ###########


########## Tcl recorder starts at 09/08/09 22:52:42 ##########

# Commands to make the Process: 
# Generate Schematic Symbol
if [runCmd "\"$cpld_bin/naf2sym\" \"register\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:52:42 ###########


########## Tcl recorder starts at 09/08/09 22:52:50 ##########

# Commands to make the Process: 
# Hierarchy Browser
# - none -
# Application to view the Process: 
# Hierarchy Browser
if [runCmd "\"$cpld_bin/hierbro\" \"tst1016_002.jid\"  register"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:52:50 ###########


########## Tcl recorder starts at 09/08/09 22:53:12 ##########

# Commands to make the Process: 
# Generate Board-level Stamp Model
if [runCmd "\"$cpld_bin/synta\" -proj tst1016_002 -pd \"$proj_dir\" -dpm_only "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/stamppar\" -i tst1016_002   -log automake.err -target ispLSI"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:53:12 ###########


########## Tcl recorder starts at 09/08/09 22:55:15 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:55:15 ###########


########## Tcl recorder starts at 09/08/09 22:57:07 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/08/09 22:57:07 ###########


########## Tcl recorder starts at 09/10/09 21:30:54 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:30:54 ###########


########## Tcl recorder starts at 09/10/09 21:35:06 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:35:06 ###########


########## Tcl recorder starts at 09/10/09 21:35:35 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:35:35 ###########


########## Tcl recorder starts at 09/10/09 21:35:56 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:35:56 ###########


########## Tcl recorder starts at 09/10/09 21:36:28 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:36:28 ###########


########## Tcl recorder starts at 09/10/09 21:36:40 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:36:40 ###########


########## Tcl recorder starts at 09/10/09 21:37:00 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:37:00 ###########


########## Tcl recorder starts at 09/10/09 21:37:08 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:37:08 ###########


########## Tcl recorder starts at 09/10/09 21:37:29 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:37:29 ###########


########## Tcl recorder starts at 09/10/09 21:37:51 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:37:51 ###########


########## Tcl recorder starts at 09/10/09 21:38:03 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:38:03 ###########


########## Tcl recorder starts at 09/10/09 21:39:01 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:39:01 ###########


########## Tcl recorder starts at 09/10/09 21:39:21 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 09/10/09 21:39:21 ###########


########## Tcl recorder starts at 11/05/09 20:40:28 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/05/09 20:40:28 ###########


########## Tcl recorder starts at 11/05/09 20:41:54 ##########

# Commands to make the Process: 
# Fit Design
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/synsvf\" -exe \"$install_dir/ispvmsystem/ispufw\" -prj tst1016_002 -if tst1016_002.jed -j2s -log tst1016_002.svl "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/05/09 20:41:54 ###########


########## Tcl recorder starts at 11/05/09 20:42:08 ##########

# Commands to make the Process: 
# Timing Analysis
if [runCmd "\"$cpld_bin/synta\" -proj tst1016_002 -pd \"$proj_dir\" -dpm_only "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/05/09 20:42:08 ###########


########## Tcl recorder starts at 11/05/09 20:42:57 ##########

# Commands to make the Process: 
# Functional Simulation
# - none -
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/05/09 20:42:57 ###########


########## Tcl recorder starts at 11/05/09 20:44:01 ##########

# Commands to make the Process: 
# Stamp Model File
if [runCmd "\"$cpld_bin/stamppar\" -i tst1016_002   -log automake.err -target ispLSI"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/05/09 20:44:01 ###########


########## Tcl recorder starts at 11/05/09 20:44:10 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/05/09 20:44:10 ###########


########## Tcl recorder starts at 11/08/09 17:09:30 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/08/09 17:09:30 ###########


########## Tcl recorder starts at 11/08/09 17:31:19 ##########

# Commands to make the Process: 
# JEDEC File
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\"  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/08/09 17:31:19 ###########


########## Tcl recorder starts at 11/26/09 22:22:11 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/26/09 22:22:11 ###########


########## Tcl recorder starts at 11/27/09 18:15:01 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:15:01 ###########


########## Tcl recorder starts at 11/27/09 18:15:30 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:15:30 ###########


########## Tcl recorder starts at 11/27/09 18:15:34 ##########

# Commands to make the Process: 
# Compile Logic
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:15:34 ###########


########## Tcl recorder starts at 11/27/09 18:15:43 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:15:43 ###########


########## Tcl recorder starts at 11/27/09 18:18:45 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:18:45 ###########


########## Tcl recorder starts at 11/27/09 18:18:49 ##########

# Commands to make the Process: 
# Timing Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\"  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Timing Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.post1 -ini simcpls.ini -all simcp.post1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:18:49 ###########


########## Tcl recorder starts at 11/27/09 18:19:28 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:19:28 ###########


########## Tcl recorder starts at 11/27/09 18:20:53 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:20:53 ###########


########## Tcl recorder starts at 11/27/09 18:21:02 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:21:02 ###########


########## Tcl recorder starts at 11/27/09 18:43:16 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:43:16 ###########


########## Tcl recorder starts at 11/27/09 18:56:30 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:56:30 ###########


########## Tcl recorder starts at 11/27/09 18:56:54 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:56:54 ###########


########## Tcl recorder starts at 11/27/09 18:57:11 ##########

# Commands to make the Process: 
# JEDEC File
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 18:57:11 ###########


########## Tcl recorder starts at 11/27/09 20:40:32 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 20:40:32 ###########


########## Tcl recorder starts at 11/27/09 23:22:04 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 23:22:04 ###########


########## Tcl recorder starts at 11/27/09 23:23:58 ##########

# Commands to make the Process: 
# JEDEC File
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 11/27/09 23:23:58 ###########


########## Tcl recorder starts at 12/05/09 17:25:18 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:25:18 ###########


########## Tcl recorder starts at 12/05/09 17:25:31 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:25:31 ###########


########## Tcl recorder starts at 12/05/09 17:25:47 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:25:47 ###########


########## Tcl recorder starts at 12/05/09 17:25:50 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:25:50 ###########


########## Tcl recorder starts at 12/05/09 17:26:23 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:26:23 ###########


########## Tcl recorder starts at 12/05/09 17:26:25 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:26:25 ###########


########## Tcl recorder starts at 12/05/09 17:26:41 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:26:41 ###########


########## Tcl recorder starts at 12/05/09 17:26:43 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:26:43 ###########


########## Tcl recorder starts at 12/05/09 17:28:14 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:28:14 ###########


########## Tcl recorder starts at 12/05/09 17:30:43 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:30:43 ###########


########## Tcl recorder starts at 12/05/09 17:30:50 ##########

# Commands to make the Process: 
# Constraint Editor
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:30:50 ###########


########## Tcl recorder starts at 12/05/09 17:34:18 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:34:18 ###########


########## Tcl recorder starts at 12/05/09 17:38:44 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:38:44 ###########


########## Tcl recorder starts at 12/05/09 17:38:46 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:38:46 ###########


########## Tcl recorder starts at 12/05/09 17:41:23 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:41:23 ###########


########## Tcl recorder starts at 12/05/09 17:41:30 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:41:30 ###########


########## Tcl recorder starts at 12/05/09 17:44:09 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:44:09 ###########


########## Tcl recorder starts at 12/05/09 17:44:16 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:44:16 ###########


########## Tcl recorder starts at 12/05/09 17:52:08 ##########

# Commands to make the Process: 
# Compiled Equations
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.eq0\" -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:52:08 ###########


########## Tcl recorder starts at 12/05/09 17:52:20 ##########

# Commands to make the Process: 
# Functional Simulation
# - none -
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:52:20 ###########


########## Tcl recorder starts at 12/05/09 17:54:15 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:54:15 ###########


########## Tcl recorder starts at 12/05/09 17:54:21 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:54:21 ###########


########## Tcl recorder starts at 12/05/09 17:56:02 ##########

# Commands to make the Process: 
# Hierarchy
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -ojhd only -def _PLSI_ _LATTICE_  -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:56:02 ###########


########## Tcl recorder starts at 12/05/09 17:56:11 ##########

# Commands to make the Process: 
# Functional Simulation
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -vec -ovec \"register.tmv\" -sim tst1016_002  -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/ahdl2blf\" \"register.abl\" -mod register -ojhd compile -prj tst1016_002 -def _PLSI_ _LATTICE_  -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/blif2eqn\" \"register.bl0\" -o \"register.lsi\" -template \"$install_dir/ispcpld/plsi/latsim/plsi.tft\" -testfix -bus rebuild -prj tst1016_002 -err automake.err"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -o \"register.blo\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.blo\" -o \"tst1016_002.blh\" -omod tst1016_002 -propadd -family PLSI -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" \"tst1016_002.blh\" -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i \"tst1016_002.bli\" -o \"tst1016_002.blj\" -idev PLSI -propadd -dev pla_basic -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Functional Simulation
if [catch {open simcp._sp w} rspFile] {
	puts stderr "Cannot create response file simcp._sp: $rspFile"
} else {
	puts $rspFile "simcp.pre1 -ini simcpls.ini -unit simcp.pre1
-cfg plsi.fdk \"register.lts\" -map \"register.lsi\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/simcp\" @simcp._sp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:56:11 ###########


########## Tcl recorder starts at 12/05/09 17:56:31 ##########

# Commands to make the Process: 
# JEDEC File
if [catch {open copytmv.bat w} rspFile] {
	puts stderr "Cannot create response file copytmv.bat: $rspFile"
} else {
	puts $rspFile "Copy register.tmv tst1016_002.dtv
if \"register.tmv\"==\"tst1016_002.tmv\" goto end
Copy register.tmv tst1016_002.tmv
:end
"
	close $rspFile
}
if [runCmd "\"copytmv\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete copytmv.bat
if [runCmd "\"$cpld_bin/iblifopt\" \"register.bl0\" -red bypin choose -collapse -pterms 8 -family -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblflink\" \"register.bl1\" -o \"tst1016_002.bl2\" -omod register -propadd -family PLSI -ues tst1016_002.ues -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/iblifopt\" tst1016_002.bl2 -red bypin choose -sweep -collapse all -pterms 8 -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/idiofft\" -i tst1016_002.bl3 -o tst1016_002.tt2 -propadd -idev PLSI -dev pla_basic -pla -err automake.err "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.tt2 -if pla -p ispLSI1016-60LH44/883 -pre "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$install_dir/ispcomp/bin/impsrclever\" -prj tst1016_002 -log tst1016_002.irs "] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 17:56:32 ###########


########## Tcl recorder starts at 12/05/09 18:59:53 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 18:59:53 ###########


########## Tcl recorder starts at 12/05/09 19:00:32 ##########

# Commands to make the Process: 
# JEDEC File
if [runCmd "\"$cpld_bin/syndpm\" -i tst1016_002.laf -if laf -p ispLSI1016-60LH44/883 -pd \"$proj_dir\"  -of vhdl -of verilog"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 19:00:32 ###########


########## Tcl recorder starts at 12/05/09 19:03:43 ##########

# Commands to make the Process: 
# Constraint Editor
# - none -
# Application to view the Process: 
# Constraint Editor
if [catch {open ce.rsp w} rspFile] {
	puts stderr "Cannot create response file ce.rsp: $rspFile"
} else {
	puts $rspFile "-devfile \"$install_dir/ispcpld/data/lc1k/l1016_44h.dev\"
-lci tst1016_002.lct
-touch tst1016_002.irs
-src tst1016_002.tt2
-type PLA
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/lciedit\" @ce.rsp"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 12/05/09 19:03:43 ###########

