// tstintLsi.c

//-----------------------------------------------------------------------
//
//	Programme de test de l'interface a ispLSI1016 via l'interface USB2Peri1
//	---------------------------------------------------------------------
//
//	A utiliser avec :
//	Programme Usb2Peri1V1.x du PIC 18F4550 (test avec 1.1)
//
//	(C) 2009 CHAMOUARD
//
//  (Libre de droits pour utilisation non commerciale 
//	et  vos propres risques)
//
//-----------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "..\libelec\USB2Peri1Lib.h"

int main()
{
	int res, i, j;

	res=per1_init();
	if(res!=0)
	{
		printf("Initialisation incorrecte de la carte USB2Peri1, Erreur=%d\n",res);
		return(0);
	}
	printf("Initialisation correcte de l'interface USB2Peri1\n\n");

	printf("Test d'ecriture/lecture a l'adresse 0x00 ");	
	res=0;
	for(i=0;i<256;++i)
	{
		per1_write(0, i);
		j=per1_read(0);
		if(j!=i)
		{
			printf("\nKO ; Ecriture : %2.2x Lecture : %2.2x", i, j);
			res=1;
		}
	}
	if(res==0)printf("OK\n");
	else
	{
		printf("\n\n");
		printf("Taper une touche ");
		while(!kbhit());
	}
	
	printf("Test lecture a l'adresse 0x01 ");
	j=per1_read(1);
	if(j!=0x00)
	{
		printf("\nKO ; Lecture : %2.2x\n\n", j);
		printf("Taper une touche ");
		while(!kbhit());
	}

	printf("OK \nTest lecture a l'adresse 0x02 ");
	j=per1_read(2);
	if(j!=0xff)
	{
		printf("\nKO ; Lecture : %2.2x\n\n", j);
		printf("Taper une touche ");
		while(!kbhit());
	}

	printf("OK\nTest lecture a l'adresse 0x04 ");
	j=per1_read(4);
	if(j!=0x55)
	{
		printf("\nKO ; Lecture : %2.2x\n\n", j);
		printf("Taper une touche ");
		while(!kbhit());
	}

	printf("OK\nTest lecture a l'adresse 0x08 ");
	j=per1_read(8);
	if(j!=0xaa)
	{
		printf("\nKO ; Lecture : %2.2x\n\n", j);
		printf("Taper une touche ");
		while(!kbhit());
	}

	printf("OK\nTest lecture a l'adresse 0x10 ");
	j=per1_read(16);
	if(j!=0x33)
	{
		printf("\nKO ; Lecture : %2.2x\n\n", j);
		printf("Taper une touche ");
		while(!kbhit());
	}

	printf("OK\nTest lecture a l'adresse 0x20 ");
	j=per1_read(32);
	if(j!=0xec)
	{
		printf("\nKO ; Lecture : %2.2x\n\n", j);
		printf("Taper une touche ");
		while(!kbhit());
	}

	printf("OK\n\nTous les tests sont OK\n\nTaper une touche ");
	while(!kbhit());

	return(0);
}