// tstPaP.c

//-----------------------------------------------------------------------
//
//	Programme de test d'un moteur pas  pas via l'interface USB2Peri1
//	---------------------------------------------------------------------
//
//	A utiliser avec :
//	Programme Usb2Peri1V1.x du PIC 18F4550 (test avec 1.0)
//	Le moteur pas  pas est connect sur les bits D0  D3 du port 0
//
//	(C) 2009 CHAMOUARD
//
//  (Libre de droits pour utilisation non commerciale 
//	et  vos propres risques)
//
//-----------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "..\libelec\USB2Peri1Lib.h"

#define AddWrite	0
#define Nord		1
#define Est			8
#define	Sud			2
#define	Ouest		4


int	pap_cmd=Nord;

void pap_normal_next()
{
	switch(pap_cmd)
	{
	case Nord:	pap_cmd=Est;	break;
	case Est:	pap_cmd=Sud;	break;
	case Sud:	pap_cmd=Ouest;	break;
	case Ouest:	pap_cmd=Nord;	break;
	default:pap_cmd=Nord;
	}
	per1_write(AddWrite, pap_cmd);
}

void pap_normal_previous()
{
	switch(pap_cmd)
	{
	case Nord:	pap_cmd=Ouest;	break;
	case Ouest:	pap_cmd=Sud;	break;
	case Sud:	pap_cmd=Est;	break;
	case Est:	pap_cmd=Nord;	break;
	default:pap_cmd=Nord;
	}
	per1_write(AddWrite, pap_cmd);
}

void pap_double_next()
{
	switch(pap_cmd)
	{
	case Nord+Est:	pap_cmd=Est+Sud;	break;
	case Est+Sud:	pap_cmd=Sud+Ouest;	break;
	case Sud+Ouest:	pap_cmd=Ouest+Nord;	break;
	case Ouest+Nord:pap_cmd=Nord+Est;	break;
	default:pap_cmd=Nord+Est;
	}
	per1_write(AddWrite, pap_cmd);
}

void pap_double_previous()
{
	switch(pap_cmd)
	{
	case Nord+Est:	pap_cmd=Ouest+Nord;	break;
	case Ouest+Nord:pap_cmd=Sud+Ouest;	break;
	case Sud+Ouest:	pap_cmd=Est+Sud;	break;
	case Est+Sud:	pap_cmd=Nord+Est;	break;
	default:pap_cmd=Nord+Est;
	}
	per1_write(AddWrite, pap_cmd);
}

void pap_demi_next()
{
	switch(pap_cmd)
	{
	case Nord:		pap_cmd=Nord+Est;	break;
	case Nord+Est:	pap_cmd=Est;		break;
	case Est:		pap_cmd=Est+Sud;	break;
	case Est+Sud:	pap_cmd=Sud;		break;
	case Sud:		pap_cmd=Sud+Ouest;	break;
	case Sud+Ouest:	pap_cmd=Ouest;		break;
	case Ouest:		pap_cmd=Ouest+Nord;	break;
	case Ouest+Nord:pap_cmd=Nord;		break;
	default:pap_cmd=Nord;
	}
	per1_write(AddWrite, pap_cmd);
}

void pap_demi_previous()
{
	switch(pap_cmd)
	{
	case Nord:		pap_cmd=Nord+Ouest;	break;
	case Nord+Ouest:pap_cmd=Ouest;		break;
	case Ouest:		pap_cmd=Ouest+Sud;	break;
	case Ouest+Sud:	pap_cmd=Sud;		break;
	case Sud:		pap_cmd=Sud+Est;	break;
	case Sud+Est:	pap_cmd=Est;		break;
	case Est:		pap_cmd=Est+Nord;	break;
	case Est+Nord:	pap_cmd=Nord;		break;
	default:pap_cmd=Nord;
	}
	per1_write(AddWrite, pap_cmd);
}

int main()
{
	int res;

	res=per1_init();
	if(res!=0)
	{
		printf("Initialisation incorrecte de la carte USB2Peri1, Erreur=%d\n",res);
		return(0);
	}
	printf("Initialisation correcte de l'interface USB2Peri1\n");
	
	do
	{
		_sleep(1000);
		pap_double_previous();
	}
	while(!kbhit());
	
	return(0);
}