; LIBASC.ASM
;
;    Bibliotheque de sous-programmes de gestion des carracteres ASCII
;    ----------------------------------------------------------------
;
;                     (C) E+E CHAMOUARD 1993-2002
;
; Conversions ASCII <-> Hexa sur un caractere
;   AscHexa2Car passe d'un octet (0 a Fh) en caractere ASCII (0 a F)
;   AscCar2Hexa passe d'un caractere ASCII (0 a 9 et A a F) en hexa (0 a Fh)
; Conversions Hexa -> ASCII en memoire interne
;   AscHexa2AsciidecInt passe de 4 bits en decimal ASCII (00 a 15) en memoire interne
;   AscByte2AsciidecInt passe de 8 bits en decimal ASCII (000 a 255) en memoire interne
;   AscWord2AsciidecInt passe de 16 bits en decimal ASCII (0000 a FFFF) en memoire interne
;   AscHexa2AsciihexInt passe de 4 bits en hexadecimal ASCII (0 a F) en memoire interne
;   AscByte2AsciihexInt passe de 8 bits en hexadecimal ASCII (00 a FF) en memoire interne
;   AscWord2AsciihexInt passe de 16 bits en hexadecimal ASCII (0000 a FFFF) en memoire interne
; Conversions ASCII -> Hexa en memoire interne
;   AscAsciihexInt2Hexa passe d'un hexadecimal ASCII (0 a F) en memoire interne en 4 bits
;   AscAsciihexInt2Byte passe de deux hexadecimal ASCII (00 a FF) en memoire interne en 8 bits
;   AscAsciihexInt2Word passe de quatre hexadecimal ASCII (0000 a FFFF) en memoire interne en 16 bits
; Passage minuscule <-> majuscule
;   AscCarUpcase passe un caractere ASCII en majuscule (si a a z)
;   AscCarDowncase passe un caractere ASCII en minuscule (si A a Z)
;   AscStringUpcase passe une chaine en majuscule en memoire externe
;   AscStringDowncase passe une chaine en minuscule en memoire externe
;
; A faire a terme :
;   Conversion Asciidec -> 4, 8 et 16 bits en hexa


; Conversions ASCII <-> Hexa sur un caractere
; -------------------------------------------

AscHexa2Car:
;
; Titre     :   Conversion hexa -> ASCII
;               ------------------------
;
; Entree(s) :   Hexa dans le registre A
; Sortie(s) :   Car ASCII dans le registre A et C=0
;               si pas hexa entre 0 et 15 sort '*' et C=1
; Utilise   :   Registres A et PSW
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
push    ACC
clr     C
subb    A,#10
jc      AscHexatoCar0a9
clr     C
subb    A,#6
jc      AscHexatoCarAaF
pop     ACC
mov     A,#2ah
setb    C
ret
AscHexatoCarAaF:
pop     ACC
add     A,#37h
clr     C
ret
AscHexatoCar0a9:
pop     ACC
add     A,#30h
clr     C
ret

AscCar2Hexa:
;
; Titre     :   Conversion ASCII-> Hexa
;               -----------------------
;
; Entree(s) :   Car ASCII dans le registre A
; Sortie(s) :   Hexa dans le registre A avec
;               C=0 si le car est bien un hexa
;               C=1 si le car n'etait pas un hexa (dans ce cas A=ffh)
; Utilise   :   Registres A et PSW
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
cjne    A,#'0',AscCartoHexa1
AscCartoHexa1:
jc      AscCartoHexaerreur  ; Caractere inferieur a '0'
cjne    A,#':',AscCartoHexa2
AscCartoHexa2:
jnc     AscCartoHexa3
clr     C                   ; Caractere entre '0' et '9'
subb    A,#48
clr     C
ret
AscCartoHexa3:
cjne    A,#'A',AscCartoHexa4
AscCartoHexa4:
jc      AscCartoHexaerreur  ; Caractere inferieur a 'A' et superieur a '9'
cjne    A,#'G',AscCartoHexa5
AscCartoHexa5:
jnc     AscCartoHexaerreur  ; Caractere superieur a 'F'
clr     C
subb    A,#55
clr     C
ret
AscCartoHexaerreur:
mov     A,#0ffh
setb    C
ret


; Conversions Hexa -> ASCII en memoire interne
; --------------------------------------------

AscHexa2AsciidecInt:
;
; Titre     :   Conversion de 4 bits en decimal ascii en memoire interne
;               --------------------------------------------------------
;
; Entree(s) :   Hexadecimal dans le registre A
;               R0 pointe sur la destination
; Sortie(s) :   Caracteres ascii en @R0 et @R0+1 (memoire interne) et C=0
;               R0 avance de 2 cases
;               Si hexa > 0fh retourne "**" et C=1
; Utilise   :   Registres A et B non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
clr     C
push    ACC
subb    A,#16
pop     ACC
jc      AscHexa2AsciidecIntNormal
mov     A,#'*'              ; hexa superieur a 15
mov     @R0,A
inc     R0
mov     @R0,A
inc     R0
setb    C
ret
AscHexa2AsciidecIntNormal:  ; hexa entre 0 et 15
mov     B,#10
div     AB
add     A,#'0'
mov     @R0,A
inc     R0
mov     A,B
add     A,#'0'
mov     @R0,A
inc     R0
clr     C
ret

AscByte2AsciidecInt:
;
; Titre     :   Conversion de 8 bits en decimal ascii en memoire interne
;               --------------------------------------------------------
;
; Entree(s) :   Byte dans le registre A
;               R0 pointe sur la destination
; Sortie(s) :   Caracteres ascii en @R0, @R0+1 et @R0+2 C=0
;               en memoire interne
;               R0 avance de 3 cases
; Utilise   :   Registres A et B non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
mov     B,#100
div     AB
add     A,#'0'
mov     @R0,A
inc     R0
mov     A,#10
xch     A,B
div     AB
add     A,#'0'
mov     @R0,A
inc     R0
mov     A,B
add     A,#'0'
mov     @R0,A
inc     R0
clr     C
ret

AscWord2AsciidecInt:
;
; Titre     :   Conversion de 16 bits en decimal ascii en memoire interne
;               ---------------------------------------------------------
;
; Entree(s) :   Word dans les registres {B,A} (B=MSB)
;               R0 pointe sur la destination
; Sortie(s) :   Caracteres ascii en @R0 a @R0+4 et C=0
;               en memoire interne
;               R0 avance de 5 cases
; Utilise   :   Registres DPH, DPL, B et A non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
mov     DPH,B
mov     DPL,A
mov     B,#0
AscWord2AsciidecIntB1:      ; Division par 10000
clr     C
mov     A,DPL
subb    A,#16
mov     A,DPH
subb    A,#39
jc      AscWord2AsciidecIntS1
mov     DPH,A
mov     A,DPL
subb    A,#16
mov     DPL,A
inc     B
ljmp    AscWord2AsciidecIntB1
AscWord2AsciidecIntS1:      ; Division par 10000 finie
mov     A,B
add     A,#'0'
mov     @R0,A
inc     R0
mov     B,#0
AscWord2AsciidecIntB2:      ; Division par 1000
clr     C
mov     A,DPL
subb    A,#232
mov     A,DPH
subb    A,#3
jc      AscWord2AsciidecIntS2
mov     DPH,A
mov     A,DPL
subb    A,#232
mov     DPL,A
inc     B
ljmp    AscWord2AsciidecIntB2
AscWord2AsciidecIntS2:      ; Division par 1000 finie
mov     A,B
add     A,#'0'
mov     @R0,A
inc     R0
mov     B,#0
AscWord2AsciidecIntB3:      ; Division par 100
clr     C
mov     A,DPL
subb    A,#100
mov     A,DPH
subb    A,#0
jc      AscWord2AsciidecIntS3
mov     DPH,A
mov     A,DPL
subb    A,#100
mov     DPL,A
inc     B
ljmp    AscWord2AsciidecIntB3
AscWord2AsciidecIntS3:      ; Division par 100 finie
mov     A,B
add     A,#'0'
mov     @R0,A
inc     R0
mov     B,DPL     
mov     A,#10
xch     A,B
div     AB
add     A,#'0'
mov     @R0,A
inc     R0
mov     A,B
add     A,#'0'
mov     @R0,A
inc     R0
clr     C
ret

AscHexa2AsciihexInt:
;
; Titre     :   Conversion de 4 bits en hexadecimal ascii en memoire interne
;               ------------------------------------------------------------
;
; Entree(s) :   Hexadecimal dans le registre A
;               R0 pointe sur la destination
; Sortie(s) :   Caractere ascii en @R0 (memoire interne) et C=0
;               R0 avance de 1 case
;               Si hexa > 0fh retourne "*" et C=1
; Utilise   :   Registre A non sauvegarde
; Pile      :   5 avec l'appel
; Cycles    :   ?
;
lcall   AscHexa2Car
mov     @R0,A
inc     R0
ret

AscByte2AsciihexInt:
;
; Titre     :   Conversion de 8 bits en hexadecimal ascii en memoire interne
;               ------------------------------------------------------------
;
; Entree(s) :   Byte dans le registre A
;               R0 pointe sur la destination
; Sortie(s) :   Caracteres ascii en @R0 et @R0+1 (memoire interne) et C=0
;               R0 avance de 2 cases
; Utilise   :   Registre A non sauvegarde
; Pile      :   6 avec l'appel
; Cycles    :   ?
;
push    ACC
anl     A,#f0h
swap    A
lcall   AscHexa2Car
mov     @R0,A
inc     R0
pop     ACC
anl     A,#0fh
lcall   AscHexa2Car
mov     @R0,A
inc     R0
clr     C
ret

AscWord2AsciihexInt:
;
; Titre     :   Conversion de 16 bits en hexadecimal ascii en memoire interne
;               -------------------------------------------------------------
;
; Entree(s) :   Word dans les registres {B,A} (B=MSB)
;               R0 pointe sur la destination
; Sortie(s) :   Caracteres ascii en @R0 a @R0+3 (memoire interne) et C=0
;               R0 avance de 4 cases
; Utilise   :   Registres A et B non sauvegardes
; Pile      :   6 avec l'appel
; Cycles    :   ?
;
push    ACC
mov     A,B
anl     A,#f0h
swap    A
lcall   AscHexa2Car
mov     @R0,A
inc     R0
mov     A,B
anl     A,#0fh
lcall   AscHexa2Car
mov     @R0,A
inc     R0
pop     B
mov     A,B
anl     A,#f0h
swap    A
lcall   AscHexa2Car
mov     @R0,A
inc     R0
mov     A,B
anl     A,#0fh
lcall   AscHexa2Car
mov     @R0,A
inc     R0
clr     C
ret


; Conversions ASCII -> Hexa en memoire interne
; --------------------------------------------

AscAsciihexInt2Hexa:
;
; Titre     :   Conversion d'un hexadecimal ascii en memoire interne en 4 bits
;               --------------------------------------------------------------
;
; Entree(s) :   R0 pointe sur le caractere a convertir
; Sortie(s) :   Hexadecimal dans le registre A et C=0 si @R0 est un hexa (R0 avance d'une case)
;               ou ffh dans A, C=1 et R0 ne bouge pas si le caractere n'est pas un hexa
; Utilise   :   Registres A et PSW non sauvegardes
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
mov     A,@R0
lcall   AscCar2Hexa
jc      AsciihexInt2HexaFin
inc     R0
AsciihexInt2HexaFin:
ret

AscAsciihexInt2Byte:
;
; Titre     :   Conversion de deux hexadecimal ascii en memoire interne en 8 bits
;               -----------------------------------------------------------------
;
; Entree(s) :   R0 pointe sur les caracteres a convertir
; Sortie(s) :   Octet dans le registre A et C=0 si @R0 et @R0+1 forment un octet
;               (R0 avance de 2 cases) ou ffh dans A, C=1 et R0 ne bouge pas si les
;               caracteres ne sont pas des hexa
; Utilise   :   Registres A, B et PSW non sauvegardes
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
mov     A,@R0
lcall   AscCar2Hexa
jc      AscAsciihexInt2ByteFin
swap    A
mov     B,A
inc     R0
mov     A,@R0
lcall   AscCar2Hexa
jc      AscAsciihexInt2ByteErreur
orl     A,B
clr     C
inc     R0
AscAsciihexInt2ByteFin:
ret
AscAsciihexInt2ByteErreur:
dec     R0
ret

AscAsciihexInt2Word:
;
; Titre     :   Conversion de quatre hexadecimal ascii en memoire interne en 16 bits
;               --------------------------------------------------------------------
;
; Entree(s) :   R0 pointe sur les caracteres a convertir
; Sortie(s) :   Word dans {B,A} (B=MSB) et C=0 si @R0 a @R0+3 forment un octet
;               (R0 avance de 4 cases) ou ffffh dans {B,A}, C=1 et R0 ne bouge pas si
;               les caracteres ne sont pas des hexa
; Utilise   :   Registres A, B et PSW non sauvegardes
; Pile      :   7 avec l'appel
; Cycles    :   ?
;
lcall   AscAsciihexInt2Byte
jc      AscAsciihexInt2WordErreur
push    ACC
lcall   AscAsciihexInt2Byte
jc      AscAsciihexInt2WordErreur2
pop     B
ret
AscAsciihexInt2WordErreur:
mov     A,#ffh
mov     B,#ffh
setb    C
ret
AscAsciihexInt2WordErreur2:
pop     ACC
dec     R0
dec     R0
mov     A,#ffh
mov     B,#ffh
setb    C
ret


; Passage minuscule <-> majuscule
; -------------------------------

AscCarUpcase:
;
; Titre     :   Passage d'un caractere en majuscule
;               -----------------------------------
;
; Entree(s) :   Car ASCII dans le registre A
; Sortie(s) :   Car ASCII en majuscule dans le registre A
;               ne change rien si non compris entre a et z
; Utilise   :   Registre A
; Pile      :   2 avec l'appel
; Cycles    :   8 a 13
;
cjne    A,#'a',AscCarUpcase1
AscCarUpcase1:
jc      AscCarUpcasefin
cjne    A,#'{',AscCarUpcase2
AscCarUpcase2:
jnc     AscCarUpcasefin
anl     A,#11011111b
AscCarUpcasefin:
ret

AscCarDowncase:
;
; Titre     :   Passage d'un caractere en minuscule
;               -----------------------------------
;
; Entree(s) :   Car ASCII dans le registre A
; Sortie(s) :   Car ASCII en minuscule dans le registre A
;               ne change rien si non compris entre A et Z
; Utilise   :   Registre A
; Pile      :   2 avec l'appel
; Cycles    :   8 a 13
;
cjne    A,#'A',AscCarDowncase1
AscCarDowncase1:
jc      AscCarDowncasefin
cjne    A,#'{',AscCarDowncase2
AscCarDowncase2:
jnc     AscCarDowncasefin
orl     A,#00100000b
AscCarDowncasefin:
ret

AscStringUpcase:
;
; Titre     :   Passage en majuscule d'une chaine ascii en memoire externe
;               ----------------------------------------------------------
;
; Entree(s) :   DPTR pointe sur la chaine (terminee par un 0) a convertir
; Sortie(s) :   Chaine passee en majuscule
; Utilise   :   Registres A et DPTR non sauvegardes
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
movx    A,@DPTR
jz      AscStringUpcaseFin
lcall   AscCarUpcase
movx    @DPTR,A
inc     DPTR
sjmp    AscStringUpcase
AscStringUpcaseFin:
ret

AscStringDowncase:
;
; Titre     :   Passage en minuscule d'une chaine ascii en memoire externe
;               ----------------------------------------------------------
;
; Entree(s) :   DPTR pointe sur la chaine (terminee par un 0) a convertir
; Sortie(s) :   Chaine passee en minuscule
; Utilise   :   Registres A et DPTR non sauvegardes
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
movx    A,@DPTR
jz      AscStringDowncaseFin
lcall   AscCarDowncase
movx    @DPTR,A
inc     DPTR
sjmp    AscStringDowncase
AscStringDowncaseFin:
ret
