; LIBCLA1.ASM

;
;    Bibliotheque de sous-programmes de gestion du clavier standard
;    --------------------------------------------------------------
;
;                     (C) E+E CHAMOUARD 1993
;

; Le clavier standard est le clavier 16 touches avec 6 leds

; A definir dans le programme principal :
;      ClaAdd		Adresse de lecture/ecriture du clavier
;      ClaLedReg      	Numero du registre de sauvegarde des LEDs
;      ClaAntiRebondDly Delai pour l'anti rebond des touches (en ms a 12 MHz)

; A inclure dans le programme principal : LIBRET.ASM

ClaRead:
;
; Titre     :   Lecture du clavier
;               ------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Dans A : 0 si pas de touche
;                        1 si double frappe
;                        10 a 1F si frappe d'une touche valide
; Utilise   :   Registre DPH, DPL, A et PSW non sauvegardes
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
mov     DPTR,#ClaAdd
mov     A,ClaLedReg
cpl     A
anl     A,#3fh
orl     A,#40h
movx    @DPTR,A
movx    A,@DPTR     ; Lecture des touches 0 a 7
push    ACC
mov     A,ClaLedReg
cpl     A
anl     A,#3fh
orl     A,#80h
movx    @DPTR,A
movx    A,@DPTR     ; Lecture des touches 8 a F
push    ACC
mov     A,ClaLedReg
cpl     A
anl     A,#3fh
movx    @DPTR,A     ; Mise au repos du clavier
pop     ACC
cjne    A,#0,ClaReadTouche8f
pop     ACC
cjne    A,#0,ClaReadTouche07
mov     A,#0        ; Aucune touche active
ret
ClaReadTouche07:
mov     DPL,#10h
sjmp    ClaReadEncode
ClaReadTouche8f:
pop     DPH
xch     A,DPH
cjne    A,#0,ClaReadDouble ; Verif double touche
xch     A,DPH
mov     DPL,#18h
ClaReadEncode:
jnb     ACC.0,ClaReadSuite
anl     A,#0feh     ; Verification double touche
jnz     ClaReadDouble
mov     A,DPL       ; Sortie car touche valide
ret
ClaReadSuite:
inc     DPL         ; Incrementation du numero de touche
rr      A           ; Rotation de l'accumulateur
sjmp    ClaReadEncode
ClaReadDouble:
mov     A,#1        ; Au moins deux touches actives
ret

ClaAntiRebond:
;
; Titre     :   Anti rebond pour le clavier
;               -----------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registres DPH, DPL, PSW, A et B non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   Indefini
;
mov     DPTR,#ClaAdd
mov     A,ClaLedReg
cpl     A
anl     A,#3fh
orl     A,#0c0h
movx    @DPTR,A     ; Toutes les touches actives
ClaAntiRebondStop:
movx    A,@DPTR     ; Lecture des touches
cjne    A,#0,ClaAntiRebondStop ; Attente de toute touche inactive
mov     B,#200
ClaAntiRebondB1:    ; Test d'un rebond d'une touche
push    B           ;  duree = 200 * ClaAntiRebonDly * 5 * 12 / CLK 
mov     B,#ClaAntiRebonDly	; soit ClaAntiRebonDly ms a 12 MHz
ClaAntiRebondB2:
nop
nop
nop
djnz    B,ClaAntiRebondB2
pop     B
movx    A,@DPTR
cjne    A,#0,ClaAntiRebondStop ; Verif de toute touche inactive
djnz    B,ClaAntiRebondB1
mov     DPTR,#ClaAdd ; Mise au repos du clavier et sortie
mov     A,ClaLedReg
cpl     A
anl     A,#3fh
movx    @DPTR,A     ; Toutes les touches non actives
ret

ClaReadTouche:
;
; Titre     :   Lecture d'une touche valide avec attente et antirebond
;               ------------------------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   N de la touche dans A
; Utilise   :   Registres DPL, DPH, PSW, A et B non sauvegardes
; Pile      :   4 avec l'appel, ClaRead et ClaAntiRebond
; Cycles    :   Indefini (attend touche valide)
;
lcall   ClaRead
jz      ClaReadTouche 	; Boucle en attente d'une touche
cjne    A,#1,ClaReadToucheFin
lcall   ClaAntiRebond 	; Cas d'une double touche
ljmp    ClaReadTouche
ClaReadToucheFin:      	; Touche valide
push    ACC
lcall   ClaAntiRebond
pop     ACC
ret

ClaWriteLED:
;
; Titre     :   Ecriture sur le port des LEDs
;               -----------------------------
;
; Entree(s) :   Donnee dans le registre ClaLedReg (LEDs actives a 1)
; Sortie(s) :   Rien
; Utilise   :   Registres A, PSW, DPL et DPH non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
mov     DPTR,#ClaAdd
mov     A,ClaLedReg
cpl     A           ; LEDs actives a 0 physiquement
anl     A,#3fh      ; Que 6 LEDs !
movx    @DPTR,A
ret

ClaTestLed:
;
; Titre     :   Sous programme de test des LEDs
;               -------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien (leds eteintes)
; Utilise   :   Registres ClaLedReg, A, DPH et DPL non sauvegardes
; Pile      :   7 avec l'appel et les sous progs
; Cycles    :   ?
;
mov     ClaLedReg,#00h
lcall   ClaWriteLED
mov     A,#200
lcall   Ret2ms
mov     ClaLedReg,#01h
lcall   ClaWriteLED
mov     A,#50
lcall   Ret2ms
mov     ClaLedReg,#02h
lcall   ClaWriteLED
mov     A,#50
lcall   Ret2ms
mov     ClaLedReg,#04h
lcall   ClaWriteLED
mov     A,#50
lcall   Ret2ms
mov     ClaLedReg,#08h
lcall   ClaWriteLED
mov     A,#50
lcall   Ret2ms
mov     ClaLedReg,#010h
lcall   ClaWriteLED
mov     A,#50
lcall   Ret2ms
mov     ClaLedReg,#020h
lcall   ClaWriteLED
mov     A,#50
lcall   Ret2ms
mov     ClaLedReg,#00h
lcall   ClaWriteLED
ret
