; LIBCLA2.ASM

;
;
;    Bibliotheque de sous-programmes de gestion du clavier 1-8 touches
;    -----------------------------------------------------------------
;
;                        (C) E+E CHAMOUARD 2000
;

; A definir dans le programme principal :
;      ClaAdd             Adresse de lecture du clavier
;      ClaAntiRebonDly    Delai pour l'anti rebond (par ms a 12 MHz)

; Sur ce clavier les touches ne sont pas encodees
; Le programme principal doit definir les bits sur lesquels sont
;  cablees les touches (ex: byte Tup, #08h) et assurer lui meme
;  (si besoin) la detection des touches multiples

ClaRead:
;
; Titre     :   Lecture du clavier 1-8 touches
;               ------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Code de la touche dans A ou 0 si aucune touche
; Utilise   :   Registres A, PSW, DPL et DPH non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
mov     DPTR,#ClaAdd
movx    A,@DPTR
ret

ClaAntiRebond:
;
; Titre     :   Anti-rebond pour le clavier 1-8 touches
;               ---------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registres A, B, PSW, DPL et DPH non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
mov     DPTR,#ClaAdd
ClaAntiRebondStop:
movx    A,@DPTR     ; Lecture des touches
cjne    A,#0,ClaAntiRebondStop ; Attente de toute touche inactive
mov     B,#200
ClaAntiRebondB1:    ; Test d'un rebond d'une touche
push    B           ;  duree = 200 * ClaAntiRebonDly * 5 * 12 / CLK 
mov     B,#ClaAntiRebonDly	; soit ClaAntiRebonDly ms a 12 MHz
ClaAntiRebondB2:
nop
nop
nop
djnz    B,ClaAntiRebondB2
pop     B
movx    A,@DPTR
cjne    A,#0,ClaAntiRebondStop ; Verif de toute touche inactive
djnz    B,ClaAntiRebondB1
ret
