; LIBCOM1.ASM

;
;    Bibliotheque de sous-programmes de gestion de la liaison serie
;    --------------------------------------------------------------
;
;                    (C) E+E CHAMOUARD 1993-2001
;
;
; Cette version gere une liaison serie sans interuption et sans buffer.
; Elle utilise une liaison de vitesse variable sur 7 bits avec parite paire.
; Le timer utilise est le Timer 1 en 8 bits autoreload.
; La liaison est en double vitesse.
;
; Utilisation :
;   Initialisation de la liaison :
;       ComInit (ou ComInitWait) avec dans A une constante ComSpeed_xx_xxxxx
;       pour definir la vitesse
;   Lecture d'un caractere recu :
;       ComReadChar7s
;   Envoi de(s) caractere(s) :
;       ComWriteChar7s

; Definitions des constantes pour l'initialisation de la vitesse

byte    ComSpeed_11_1200,   #00h    ; 1200 bauds si clock=11,06 MHz
byte    ComSpeed_11_2400,   #01h    ; 2400 bauds si clock=11,06 MHz
byte    ComSpeed_11_4800,   #02h    ; 4800 bauds si clock=11,06 MHz
byte    ComSpeed_11_9600,   #03h    ; 9600 bauds si clock=11,06 MHz
byte    ComSpeed_11_14400,  #04h    ; 14400 bauds si clock=11,06 MHz
byte    ComSpeed_11_19200,  #05h    ; 19200 bauds si clock=11,06 MHz
byte    ComSpeed_11_28800,  #06h    ; 28800 bauds si clock=11,06 MHz
byte    ComSpeed_11_57600,  #07h    ; 57600 bauds si clock=11,06 MHz
byte    ComSpeed_12_1200,   #08h    ; 1200 bauds si clock=12 MHz
byte    ComSpeed_12_2400,   #09h    ; 2400 bauds si clock=12 MHz
byte    ComSpeed_12_4800,   #0ah    ; 4800 bauds si clock=12 MHz
byte    ComSpeed_12_12800,  #0bh    ; 12800 bauds si clock=12 MHz

; Definition des constantes internes :

ComSpeedTab:
db      d0h     ;  1200 bauds si clock=11,06 MHz
db      e8h     ;  2400 bauds si clock=11,06 MHz
db      f4h     ;  4800 bauds si clock=11,06 MHz
db      fah     ;  9600 bauds si clock=11,06 MHz
db      fch     ; 14400 bauds si clock=11,06 MHz
db      fdh     ; 19200 bauds si clock=11,06 MHz
db      feh     ; 28800 bauds si clock=11,06 MHz
db      ffh     ; 57600 bauds si clock=11,06 MHz
db      cch     ;  1200 bauds si clock=12 MHz (1202 exactement)
db      e6h     ;  2400 bauds si clock=12 MHz (2404 exactement)
db      f3h     ;  4800 bauds si clock=12 MHz (4808 exactement)
db      fbh     ; 12800 bauds si clock=12 MHz (12500 exactement)

ComInit:
;
; Titre     :   Initialisation de la liaison serie en 8 bits (parite par soft)
;               --------------------------------------------------------------
;
; Entree(s) :   Vitesse dans A : constantes ComSpeed_xx_xxxxx
; Sortie(s) :   Rien
; Utilise   :   Registre A (vitesse perdue) TMOD, PCON et SCON
;               Timer 1 pour la liaison serie
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
clr     TR1                     ; Stop timer 1
mov     PCON,#080h              ; Double vitesse
mov     DPTR,#ComSpeedTab       ; Lecture de la donnee pour le timer 1
movc    A,@A+DPTR
mov     TH1,A
mov     ACC,TMOD
anl     A,#0Fh
orl     A,#20h
mov     TMOD,ACC                ; Timer1 en timer 8 bits auto-reload
setb    TR1
mov     SCON,#01010010b         ; 8 bits tous messages reception
ret

ComInitWait:
;
; Titre     :   Initialisation de la liaison serie en 8 bits avec attente
;               ---------------------------------------------------------
;
; Entree(s) :   Vitesse dans A : constantes ComSpeed_xx_xxxxx
; Sortie(s) :   Rien
;               Idem ComInit avec en plus attente que la liaison soit libre
;               (plus de car dans le buffer de transmission)
; Utilise   :   Registre A (vitesse perdue) TMOD, PCON et SCON
;               Timer 1 pour la liaison serie
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
jnb     TI,$
ljmp    ComInit

ComReadChar7s:
;
; Titre     :   Reception d'un caractere sur la liaison serie (7 bits , PP, sans IT)
;               -------------------------------------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Carac eventuel dans A
;                   (=ffh si erreur de parite en mode 7 bits)
;               C=1 : si rien recu
;               C=0 : si reception
; Utilise   :   Registres ACC, PSW non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
jb      RI,ComReadChar7sOK
setb    C                       ; Pas de caractere dans le buffer
ret
ComReadChar7sOK:                ; Caractere recu
clr     RI
mov     ACC,SBUF
jnb     P,ComReadChar7sPOK
mov     ACC,#0ffh               ; A=ff car erreur de parite
clr     C
ret
ComReadChar7sPOK:               ; Parite OK
anl     A,#7fh                  ; Masque la parite
clr     C
ret

ComWriteChar7s:
;
; Titre     :   Envoi d'un caractere sur la liaison serie (7 bits, PP, sans IT)
;               --------------------------------------------------------------
;
; Entree(s) :   Carac dans A
; Sortie(s) :   Rien (carac perdu)
; Utilise   :   PSW non sauvegarde
; Pile      :   2 avec l'appel
; Cycles    :   Indetermine (attente que la liaison soit libre)
;
anl     A,#7fh                  ; Conversion 7->8 bits
mov     C,P
;cpl     C
mov     ACC.7,C
jnb     TI,$
clr     TI
mov     SBUF,A
ret
