; LIBCOM2.ASM

;
;    Bibliotheque de sous-programmes de gestion de la liaison serie
;    --------------------------------------------------------------
;
;                    (C) E+E CHAMOUARD 1993-2001
;
;
; Cette version gere une liaison serie sans interuption et sans buffer.
; Elle utilise une liaison de vitesse variable sur 8 bits sans parite.
; Le timer utilise est le Timer 1 en 8 bits autoreload.
; La liaison est en double vitesse.
;
; Utilisation :
;   Initialisation de la liaison :
;       ComInit (ou ComInitWait) avec dans A une constante ComSpeed_xx_xxxxx
;       pour definir la vitesse
;   Lecture d'un caractere recu :
;       ComReadChar8s
;   Envoi de(s) caractere(s) :
;       ComWriteChar8s
;
; Le programme doit include LIBCOM1.ASM (les initialisation sont identiques)

ComReadChar8s:
;
; Titre     :   Reception d'un caractere sur la liaison serie (8 bits , sans parite, sans IT)
;               -----------------------------------------------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Carac eventuel dans A
;               C=1 : si rien recu
;               C=0 : si reception
; Utilise   :   Registres ACC, PSW non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
jb      RI,ComReadChar8sOK
setb    C                       ; Pas de caractere dans le buffer
ret
ComReadChar8sOK:                ; Caractere recu
clr     RI
mov     ACC,SBUF
clr     C
ret

ComWriteChar8s:
;
; Titre     :   Envoi d'un caractere sur la liaison serie (8 bits, sans parite, sans IT)
;               ------------------------------------------------------------------------
;
; Entree(s) :   Carac dans A
; Sortie(s) :   Rien (carac perdu)
; Utilise   :   PSW non sauvegarde
; Pile      :   2 avec l'appel
; Cycles    :   Indetermine (attente que la liaison soit libre)
;
jnb     TI,$
clr     TI
mov     SBUF,A
ret
