; LIBCOME.ASM
;
;    Bibliotheque de sous-programmes de gestion de la liaison serie
;    --------------------------------------------------------------
;
;                    (C) E+E CHAMOUARD 1993-2001
;
;
; Cette bibliotheque rassemble une suite de sous-programme automatisant
; certaines taches utilisant la liaison serie.
; Elle doit etre utilisee avec une bibliotheque de gestion de la laison serie
; a disposition un sous programme d'envoi des caracteres (ComWriteChar) tel
; que celui disponible dans LibCom1 (renommer par une commande
; label ComWriteChar, ComWriteChar7s entre l'include de LibCom1 et de LibComE).
;
; Inclure dans le programme principal : LIBASC.ASM et LIBCOMX.ASM ou equivalent

ComWriteByteAscii:
;
; Titre     :   Envoi d'un byte en 2 hexa en ASCII
;               ----------------------------------
;
; Entree(s) :   Byte dans le registre A
; Sortie(s) :   Rien (byte perdu)
; Utilise   :   Registre A et PSW non sauvegardes
;               + ceux utilises par ComWriteChar
; Pile      :   3 avec l'appel + utilisation de ComWriteChar
; Cycles    :   Indefini
;
push    ACC
anl     A,#f0h
swap    A
lcall   AscHexa2Car
lcall   ComWriteChar
pop     ACC
anl     A,#0fh
lcall   AscHexa2Car
lcall   ComWriteChar
ret

ComWriteWordAscii:
;
; Titre     :   Envoi d'un word en 4 hexa en ASCII
;               ----------------------------------
;
; Entree(s) :   Word dans B, A
; Sortie(s) :   Rien (A non sauvegarde)
; Utilise   :   Registres A et PSW non sauvegardes
;               + ceux utilises par ComWriteChar
; Pile      :   3 avec l'appel + utilisation de ComWriteChar
; Cycles    :   Indefini
;
push    ACC
mov     A,B
anl     A,#f0h
swap    A
lcall   AscHexa2Car
lcall   ComWriteChar
mov     A,B
anl     A,#0fh
lcall   AscHexa2Car
lcall   ComWriteChar
pop     ACC
push    ACC
anl     A,#f0h
swap    A
lcall   AscHexa2Car
lcall   ComWriteChar
pop     ACC
anl     A,#0fh
lcall   AscHexa2Car
lcall   ComWriteChar
ret

ComWriteString:
;
; Titre     :   Envoi d'une chaine sur la liaison serie
;               ---------------------------------------
;
; Entree(s) :   Chaine en espace memoire externe, terminee par 0
;               Pointee par DPTR
; Sortie(s) :   Rien (DPTR perdu)
; Utilise   :   Registres A et PSW non sauvegardes
;               + ceux utilises par ComWriteChar
; Pile      :   2 avec l'appel + utilisation de ComWriteChar
; Cycles    :   Indefini
;
movx    A,@DPTR
jz      ComWriteStringFin
lcall   ComWriteChar
inc     DPTR
sjmp    ComWriteString
ComWriteStringFin:
ret

ComWriteStringCode:
;
; Titre     :   Envoi d'une chaine sur la liaison serie
;               ---------------------------------------
;
; Entree(s) :   Chaine en espace programme, terminee par 0
;               Pointee par DPTR
; Sortie(s) :   Rien (DPTR perdu)
; Utilise   :   Registres A et PSW non sauvegardes
;               + ceux utilises par ComWriteChar
; Pile      :   2 avec l'appel + utilisation de ComWriteChar
; Cycles    :   Indefini
;
mov     A,#0
movc    A,@A+DPTR
jz      ComWriteStringCodeFin
lcall   ComWriteChar
inc     DPTR
sjmp    ComWriteStringCode
ComWriteStringCodeFin:
ret
