; LIBE2P.ASM

;              Sous-programmes de gestion des E2PROM SERIE
;              -------------------------------------------
;
;                      (C) E+E CHAMOUARD 1996
;
; Programme fonctionnant avec :
;   - E2PROM NMC9314B avec liaison 3 ou 4 fils (E2PNAD=6)
;   - E2PROM ST93CS56B1 avec liaison 3 ou 4 fils (E2PNAD=8) et ORG=+5 V
;       (hors erase et erase all non dispo avec cette PROM)

; Version avec attente systematique apres envoi d'une commande
;   (pas de time out)
; Les bits E2PDO et E2PDI peuvent etre le meme bit du uP

; A retester suite modification registres

; Dans le programme principal initialiser :
;    E2PCS  bit  Px.x
;    E2PCK  bit  Px.x
;    E2PDO  bit  Px.x
;    E2PDI  bit  Px.x
;    E2PNAD byte x (le nombre de bits d'adresse de la PROM soit 6 ou 8)

; Sous-programmes utilisateur :
; -----------------------------

E2PWriteEnable:
;
; Titre     :   Deverouillage en ecriture de l'E2PROM
;               -------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registre B non sauvegarde, bits de l'E2PROM
; Pile      :   4 avec l'appel et le sous prog
; Cycles    :   ?
;
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
clr     E2PDI
lcall   E2PClock    ; OP1=0
lcall   E2PClock    ; OP2=0
setb    E2PDI
lcall   E2PClock    ; A5 ou A7 a 1
lcall   E2PClock    ; A4 ou A6 a 1
mov     B,#E2PNAD
dec     B
dec     B
E2PWriteEnableBou:
lcall   E2PClock
djnz    B,E2PWriteEnableBou; Boucle sur E2PNAD-2 bits a 1
clr     E2PCS       ; Sortie avec CK=0,CS=0,DI=1
ret

E2PWriteDisable:
;
; Titre     :   Verrouillage en ecriture de l'E2PROM
;               ------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registre B non sauvegarde, bits de l'E2PROM
; Pile      :   4 avec l'appel et le sous prog
; Cycles    :   ?
;
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
clr     E2PDI
lcall   E2PClock    ; OP1=0
lcall   E2PClock    ; OP2=0
lcall   E2PClock    ; A5 ou A7 a 0
lcall   E2PClock    ; A4 ou A6 a 0
setb    E2PDI
mov     B,#E2PNAD
dec     B
dec     B
E2PWriteDisableBou:
lcall   E2PClock
djnz    B,E2PWriteDisableBou; Boucle sur E2PNAD-2 bits a 1
clr     E2PCS       ; Sortie avec CK=0,CS=0,DI=1
ret

E2PRead:
;
; Titre     :   Lecture de 16 bits dans l'E2PROM
;               --------------------------------
;
; Entree(s) :   Adresse dans DPL (6 ou 8 LSB) conservee
; Sortie(s) :   Sortie des 16 bits dans {B,A} (B=MSB)
; Utilise   :   Registre A,B,DPL, bits de l'E2PROM
; Pile      :   5 avec l'appel et le sous prog
; Cycles    :   ?
;
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
lcall   E2PClock    ; OP1=1
clr     E2PDI
lcall   E2PClock    ; OP2=0
push    DPL
mov     A,#E2PNAD
sjmp    E2PReadSuite2
E2PReadSuite1:
inc     A
xch     A,DPL
rl      A
xch     A,DPL
E2PReadSuite2:
cjne    A,#8,E2PReadSuite1 ; boucle jusqu'a A=8
mov     A,DPL
mov     B,#E2PNAD
pop     DPL
E2PReadBou1:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit d'adresse
rl      A
lcall   E2PClock
djnz    B,E2PReadBou1; Boucle sur les bits d'adresse
setb    E2PDI       ; Au cas ou DI et DO sont relies
mov     B,#8
E2PReadBou2:
lcall   E2PClock
rl      A
mov     C,E2PDO
mov     ACC.0,C
djnz    B,E2PReadBou2; Boucle sur les 8 premiers bits de donnee
push    ACC
mov     B,#8
E2PReadBou3:
lcall   E2PClock
rl      A
mov     C,E2PDO
mov     ACC.0,C
djnz    B,E2PReadBou3; Boucle sur les 8 derniers bits de donnee
pop     B
clr     E2PCS       ;Sortie avec CK=0,CS=0,DI=1
ret

E2PWrite:
;
; Titre     :   Ecriture de 16 bits dans l'E2PROM
;               ---------------------------------
;
; Entree(s) :   Donnees dans {B,A} (B=MSB) detruites
;               Adresse dans DPL (6 ou 8 LSB) conservee
; Sortie(s) :   Rien
; Utilise   :   Registre A,B,DPL, bits de l'E2PROM
; Pile      :   6 avec l'appel et sous progs
; Cycles    :   Indetermine
;
push    ACC
push    B
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
clr     E2PDI
lcall   E2PClock    ; OP1=0
setb    E2PDI
lcall   E2PClock    ; OP2=1
push    DPL
mov     A,#E2PNAD
sjmp    E2PWriteSuite2
E2PWriteSuite1:
inc     A
xch     A,DPL
rl      A
xch     A,DPL
E2PWriteSuite2:
cjne    A,#8,E2PWriteSuite1 ; boucle jusqu'a A=8
mov     A,DPL
mov     B,#E2PNAD
pop     DPL
E2PWriteBou1:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit d'adresse
rl      A
lcall   E2PClock
djnz    B,E2PWriteBou1; Boucle sur les bits d'adresse
pop     ACC         ; MSB de la donnee dans A
mov     B,#8
E2PWriteBou2:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit de donnee
rl      A
lcall   E2PClock
djnz    B,E2PWriteBou2; Boucle sur les 8 premiers bits de donnee
pop     ACC         ; LSB de la donnee dans A
mov     B,#8
E2PWriteBou3:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit de donnee
rl      A
lcall   E2PClock
djnz    B,E2PWriteBou3; Boucle sur les 8 derniers bits de donnee
setb    E2PDI
clr     E2PCS        ;Sortie avec CK=0,CS=0,DI=1
ljmp    E2PDataPooling

E2PErase:
;
; Titre     :   Effacage de 16 bits dans l'E2PROM
;               ---------------------------------
;
; Entree(s) :   Adresse dans DPL (6 ou 8 LSB) conservee
; Sortie(s) :   Rien
; Utilise   :   Registre A,B,DPL, bits de l'E2PROM
; Pile      :   4 avec l'appel
; Cycles    :   Indetermine
;
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
lcall   E2PClock    ; OP1=1
lcall   E2PClock    ; OP2=1
push    DPL
mov     A,#E2PNAD
sjmp    E2PEraseSuite2
E2PEraseSuite1:
inc     A
xch     A,DPL
rl      A
xch     A,DPL
E2PEraseSuite2:
cjne    A,#8,E2PEraseSuite1 ; boucle jusqu'a A=8
mov     A,DPL
mov     B,#E2PNAD
pop     DPL
E2PEraseBou1:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit d'adresse
rl      A
lcall   E2PClock
djnz    B,E2PEraseBou1; Boucle sur les bits d'adresse
setb    E2PDI
clr     E2PCS        ;Sortie avec CK=0,CS=0,DI=1
ljmp    E2PDataPooling

E2PEraseAll:
;
; Titre     :   Effacage de la totalite de l'E2PROM
;               -----------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registre B non sauvegarde, bits de l'E2PROM
; Pile      :   4 avec l'appel et le sous prog
; Cycles    :   Indetermine
;
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
clr     E2PDI
lcall   E2PClock    ; OP1=0
lcall   E2PClock    ; OP2=0
setb    E2PDI
lcall   E2PClock    ; A5 ou A7 a 1
clr     E2PDI
lcall   E2PClock    ; A4 ou A6 a 0
setb    E2PDI
mov     B,#E2PNAD
dec     B
dec     B
E2PEraseAllBou:
lcall   E2PClock
djnz    B,E2PEraseAllBou; Boucle sur E2PNAD-2 bits a 1
setb    E2PDI
clr     E2PCS        ;Sortie avec CK=0,CS=0,DI=1
ljmp    E2PDataPooling

E2PWriteAll:
;
; Titre     :   Ecriture de la totalite de l'E2PROM
;               -----------------------------------
;
; Entree(s) :   Donnees dans {B,A} (B=MSB) detruites
; Sortie(s) :   Rien
; Utilise   :   Registre A,B, bits de l'E2PROM
; Pile      :   6 avec l'appel et sous progs
; Cycles    :   Indetermine
;
push    ACC
push    B
clr     E2PCS
clr     E2PDI
lcall   E2PClock    ; Coup de securite
setb    E2PCS
setb    E2PDI
lcall   E2PClock    ; Start car CS=DI=1
clr     E2PDI
lcall   E2PClock    ; OP1=0
lcall   E2PClock    ; OP2=0
lcall   E2PClock    ; A5 ou A7 a 0
setb    E2PDI
lcall   E2PClock    ; A4 ou A6 a 1
mov     B,#E2PNAD
dec     B
dec     B
E2PWriteAllBou1:
lcall   E2PClock
djnz    B,E2PWriteAllBou1; Boucle sur E2PNAD-2 bits a 1
pop     ACC         ; MSB de la donnee dans A
mov     B,#8
E2PWriteAllBou2:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit de donnee
rl      A
lcall   E2PClock
djnz    B,E2PWriteAllBou2; Boucle sur les 8 premiers bits de donnee
pop     ACC         ; LSB de la donnee dans A
mov     B,#8
E2PWriteAllBou3:
mov     C,ACC.7
mov     E2PDI,C     ; Sortie du bit de donnee
rl      A
lcall   E2PClock
djnz    B,E2PWriteAllBou3; Boucle sur les 8 derniers bits de donnee
setb    E2PDI
clr     E2PCS        ;Sortie avec CK=0,CS=0,DI=1
ljmp    E2PDataPooling

; Sous-programmes internes :
; --------------------------

E2PDataPooling:
;
; Titre     :   Data Pooling E2PROM
;               -------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registre B sauvegarde, bits de l'E2PROM
; Pile      :   3 avec l'appel
; Cycles    :   Indetermine
;
mov     B,#10
E2PDataPooling1:
clr     E2PCS
djnz    B,E2PDataPooling1 ; Decente franche du CS
mov     B,#10
E2PDataPooling2:
setb    E2PCS
djnz    B,E2PDataPooling2 ; Montee franche du CS
E2PDataPooling3:
jnb     E2PDO,E2PDataPooling3; Attente du RDY
clr     E2PCS       ; Sortie avec CK=0,CS=0,DI=1
ret

E2PClock:
;
; Titre     :   Envoi d'une sequence clock a l'E2PROM (version E2PROM lente)
;               ------------------------------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien (5 us bas 10 us haut 5 us bas avec un uC  1 cycle par us)
; Utilise   :   E2PCK
; Pile      :   2 avec l'appel
; Cycles    :   24
;
nop
nop
nop
nop
nop
setb    E2PCK
nop
nop
nop
nop
nop
nop
nop
nop
nop
clr     E2PCK
nop
nop
nop
nop
ret
