; LIBI2C.ASM

;                 Sous-programmes de gestion du bus I2C
;                 -------------------------------------
;
;                      (C) E+E CHAMOUARD 1998
;

; Programme teste avec :
;   - PCF8583 (horloge avec RAM)
;   - DS1621  (thermometre)
;
;   Vitesse I2C inferieure a 100 KHz avec horloge a 12 MHz

; Dans le programme principal initialiser :
;   I2CSDA bit  Px.x
;   I2CSCL bit  Px.x
; et ne pas oublier d'initialiser la liaison (I2CInit) et les IT si besoin

I2CInit:
;
; Titre     :   Initialisation du bus I2C
;               -------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Rien
; Pile      :   2 avec l'appel
; Cycles    :   ?
;

I2CStop:
;
; Titre     :   Envoi d'un STOP au bus I2C
;               --------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Rien
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
clr     I2CSCL
clr     I2CSDA
nop
nop
nop
nop
setb    I2CSCL
nop
nop
nop
nop
setb    I2CSDA
nop
nop
nop
nop
ret

I2CStart:
;
; Titre     :   Envoi d'un START au bus I2C
;               ---------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Rien
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
setb    I2CSDA
nop
nop
nop
nop
nop
setb    I2CSCL
nop
nop
nop
nop
nop
clr     I2CSDA
nop
nop
nop
nop
clr     I2CSCL
ret

I2CWritebit:
;
; Titre     :   Ecriture d'un bit sur le bus I2C
;               --------------------------------
;
; Entree(s) :   bit a sortir dans C
; Sortie(s) :   Rien
; Utilise   :   Rien
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
mov     I2CSDA,C
nop
nop
nop
nop
setb    I2CSCL
nop
nop
nop
nop
clr     I2CSCL
ret

I2CReadbit:
;
; Titre     :   Lecture d'un bit sur le bus I2C
;               -------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   bit lu dans C
; Utilise   :   Rien
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
setb    I2CSDA
nop
nop
nop
nop
nop
mov     C,I2CSDA
setb    I2CSCL
nop
nop
nop
nop
clr     I2CSCL
ret

I2CWritebyte:
;
; Titre     :   Ecriture d'un octet sur le bus I2C
;               ----------------------------------
;
; Entree(s) :   Octet a sortir dans A
; Sortie(s) :   Rien
; Utilise   :   C non sauvegarde
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
mov     C,ACC.7
lcall   I2CWritebit
mov     C,ACC.6
lcall   I2CWritebit
mov     C,ACC.5
lcall   I2CWritebit
mov     C,ACC.4
lcall   I2CWritebit
mov     C,ACC.3
lcall   I2CWritebit
mov     C,ACC.2
lcall   I2CWritebit
mov     C,ACC.1
lcall   I2CWritebit
mov     C,ACC.0
lcall   I2CWritebit
ret

I2CReadbyte:
;
; Titre     :   Lecture d'un octet sur le bus I2C
;               ---------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Octet lu dans A
; Utilise   :   C non sauvegarde
; Pile      :   4 avec l'appel
; Cycles    :   ?
;
lcall   I2CReadbit
mov     ACC.7,C
lcall   I2CReadbit
mov     ACC.6,C
lcall   I2CReadbit
mov     ACC.5,C
lcall   I2CReadbit
mov     ACC.4,C
lcall   I2CReadbit
mov     ACC.3,C
lcall   I2CReadbit
mov     ACC.2,C
lcall   I2CReadbit
mov     ACC.1,C
lcall   I2CReadbit
mov     ACC.0,C
ret