; LIBINT.ASM

;
;        Entete relogeable pour programme 8031/8051/8032/8052
;        ----------------------------------------------------
;
;                     (C) E+E CHAMOUARD 2000
;

; Utilisation :
;   Au debut du source principal, definir l'adresse de debut et inclure
;   ce fichier. Puis ecrire les differents modules pour le programme a
;   utiliser au reset et sur chaque interruption.
;   Le programme est relogeable, c'est a dire qu'il peut etre utilise
;   avec un moniteur a condition que ce moniteur reoriente les
;   interruptions.

; Exemple :
;   ORG         0000h       (2000h si un moniteur occupe les 8k inferieurs)
;   INCLUDE    LIBINT.ASM
;   Begin:
;       ...
;   IE1Trt:
;       ...

; Le programme principal doit contenir les modules suivants :
;   Begin       le programme a utiliser au reset
;   IE0Trt      traitement de l'interruption externe 0
;   IE1Trt      traitement de l'interruption externe 0
;   TF0Trt      traitement de l'interruption timer 0
;   TF1Trt      traitement de l'interruption timer 1
;   TF2EXF2Trt  traitement de l'interruption timer 2
;   RITITrt     traitement des interruptions de la liaison serie

; Ce module definit l'adresse Reset

; Si l'interruption n'est pas utilisee ecrite juste un retour :
;   IE0Trt:
;       reti

Reset:
ljmp    Begin

ljmp    IE0Trt          ; Interruption externe 0
db      0,0,0,0,0

ljmp    TF0Trt          ; Interruption timer 0
db      0,0,0,0,0

ljmp    IE1Trt          ; Interruption externe 1
db      0,0,0,0,0

ljmp    TF1Trt          ; Interruption timer 1
db      0,0,0,0,0

ljmp    RITITrt         ; Interruption interface serie
db      0,0,0,0,0

ljmp    TF2EXF2Trt      ; Interruption timer 2
