; LIBJMP.ASM

;
;    Bibliotheque de sous-programmes de gestion des sauts indexes
;    ------------------------------------------------------------
;
;                      (C) E+E CHAMOUARD 2000
;

JmpTable:
; Titre     :   Saut indirect via une table
;               ---------------------------
;
; Entree(s) :   ACC le code recherche dans la table
;               Juste apres le lcall JmpTable une table de la forme :
;                   Addh,Addl,Car avec Addh,Addl l'adresse a executer si ACC=Car
;                   Addh,Addl,Car autant de fois qu'il est necessaire
;                   0,0,Addh,Addl l'adresse a executer si ACC ne correspond a aucun des
;                       Car si dessus (default)
; Sortie(s) :   Saut vers l'adresse specifiee
; Utilise   :   Registres A, PSW, B, DPL et DPH non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
pop     DPH                     ; Recuperation de l'adresse de la table
pop     DPL
mov     B, A                    ; Sauvegarde A dans B
JmpTableBoucle:
clr     A
movc    A, @A+DPTR
jnz     JmpTableTest
mov     A, #01h
movc    A, @A+DPTR
jnz     JmpTableTest
inc     DPTR                    ; Donc @DPTR=@DPTR+1=0 => jump  l'adresse qui suit
inc     DPTR
JmpTableGo:                     ; Chargement de DPTR avec @DPTR et @DPTR+1 et saut
movc    A, @A+DPTR
mov     B, A
mov     A, #01h
movc    A, @A+DPTR
mov     DPL, A
mov     DPH, B
clr     A
jmp     @A+DPTR
JmpTableTest:                   ; @DPTR ou(et) @DPTR+1 non nul
mov     A, #02h
movc    A, @A+DPTR
xrl     A, B
jz      JmpTableGo              ; Test si @DPTR+2=A de l'appel
inc     DPTR                    ; Pas le cas donc boucle
inc     DPTR
inc     DPTR
sjmp    JmpTableBoucle
