; LIBLCD.ASM

;
;   Bibliotheque de sous-programmes de commande de l'afficheur LCD 2*16
;   -------------------------------------------------------------------
;
;                          (C) E+E CHAMOUARD 1993
;

; A definir dans le programme principal :
;      LcdCmdReadAdd   Adresse de lecture des commandes a l'afficheur
;      LcdCmdWriteAdd  Adresse d'ecriture des commandes a l'afficheur
;      LcdDataReadAdd  Adresse de lecture des donnees a l'afficheur
;      LcdDataWriteAdd Adresse d'ecriture des donnees a l'afficheur

; Inclure dans le programme principal : LIBASC.ASM

; Teste avec afficheurs :
;   - EPSON EA-D16025AR (mode 8 bits de donnee)

; Sous-programmes utilisateur :
; -----------------------------

LcdWrite2Dec:
;
; Titre     :   Sortie sur l'afficheur de deux decimaux
;               ---------------------------------------
;
; Entree(s) :   Donnee dans le registre A en binaire (curseur en position valide)
; Sortie(s) :   Rien
; Utilise   :   Registres B, DPH et DPL non sauvegardes
; Pile      :   7 avec l'appel
; Cycles    :   ?
;
mov     B,#10
div     AB
lcall   AscHexa2Car
lcall   LcdWriteChar
mov     A,B
lcall   AscHexa2Car
lcall   LcdWriteChar
ret

LcdWriteByte:
;
; Titre     :   Sortie de 8 bits en 2 hexas sur l'afficheur
;               -------------------------------------------
;
; Entree(s) :   Donnee dans le registre A en binaire (curseur en position valide)
; Sortie(s) :   Rien
; Utilise   :   Registre A sauvegarde, DPH et DPL non sauvegardes
; Pile      :   7 avec l'appel
; Cycles    :   ?
;
push    ACC
anl     A,#0F0h
swap    A
lcall   AscHexa2Car
lcall   LcdWriteChar
pop     ACC
push    ACC
anl     A,#00Fh
lcall   AscHexa2Car
lcall   LcdWriteChar
pop     ACC
ret

LcdWriteChar:
; Titre     :   Sortie d'un caractere sur l'afficheur
;               -------------------------------------
;
; Entree(s) :   Donnee dans le registre A (curseur sur position valide)
; Sortie(s) :   Rien
; Utilise   :   Registres DPH et DPL non sauvegardes
; Pile      :   5 avec l'appel
; Cycles    :   ?
;
lcall   LcdWriteData
lcall   LcdReposCurseur ; Ajout suite tests avec un afficheur un peu lent
ljmp	LcdReposCurseur

LcdInit:
;
; Titre     :   Initialisation de l'afficheur LCD
;               ---------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien (afficheur efface, curseur ON)
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   5 avec l'appel
; Cycles    :   ?
;
mov     A,#38h
lcall   LcdWriteCmd
mov     A,#01h
lcall   LcdWriteCmd      ; Effacement afficheur
mov     A,#0Fh
lcall   LcdWriteCmd      ; Curseur ON
ret

LcdCurseur:
;
; Titre     :   Deplacement du curseur
;               ----------------------
;
; Entree(s) :   Position dans le registre A
; Sortie(s) :   Rien
; Utilise   :   Registres DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
anl     A,#1fh
push    ACC
clr     C
subb    A,#10h
jc      LcdCurseurOK
pop     ACC
add     A,#30h
push    ACC
LcdCurseurOK:
pop     ACC
add     A,#80h
ljmp    LcdWriteCmd

LcdRaz:
;
; Titre     :   Effacement de l'afficheur LCD
;               -----------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
mov     A,#01h
ljmp    LcdWriteCmd

LcdHome:
;
; Titre     :   Repositionnement de l'afficheur LCD
;               -----------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
mov     A,#02h
ljmp    LcdWriteCmd

LcdCurseurOn:
;
; Titre     :   Visualisation du curseur de l'afficheur LCD
;               -------------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
mov     A,#0Fh
ljmp    LcdWriteCmd

LcdCurseurOff:
;
; Titre     :   Disparition du curseur de l'afficheur LCD
;               -----------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
mov     A,#0Ch
ljmp    LcdWriteCmd

LcdWriteString:
;
; Titre     :   Ecriture d'une chaine sur l'afficheur LCD
;               -----------------------------------------
;
; Entree(s) :   DPTR pointeur sur la chaine en espace memoire externe,
;                   la chaine etant terminee par un char nul
; Sortie(s) :   Rien
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   9 avec l'appel
; Cycles    :   ?
;
movx    A,@DPTR
jz      LcdWriteStringFin
push    DPH
push    DPL
lcall   LcdWriteChar
pop     DPL
pop     DPH
inc     DPTR
sjmp    LcdWriteString
LcdWriteStringFin:
ret

LcdWriteStringCode:
;
; Titre     :   Ecriture d'une chaine sur l'afficheur LCD
;               -----------------------------------------
;
; Entree(s) :   DPTR pointeur sur la chaine en espace programme,
;                   la chaine etant terminee par un char nul
; Sortie(s) :   Rien
; Utilise   :   Registres A, DPH et DPL non sauvegardes
; Pile      :   9 avec l'appel
; Cycles    :   ?
;
mov     A,#0
movc    A,@A+DPTR
jz      LcdWriteStringCodeFin
push    DPH
push    DPL
lcall   LcdWriteChar
pop     DPL
pop     DPH
inc     DPTR
sjmp    LcdWriteStringCode
LcdWriteStringCodeFin:
ret

; Sous-programmes internes :
; --------------------------

LcdWriteCmd:
;
; Titre     :   Ecriture d'une commande a l'afficheur LCD
;               -----------------------------------------
;
; Entree(s) :   Commande dans le registre A
; Sortie(s) :   Rien
; Utilise   :   Registres DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
push    ACC
LcdWriteCmdloop:
mov     DPTR,#LcdCmdReadAdd
movx    A,@DPTR     ; Lecture status de l'afficheur
jb	ACC.7,LcdWriteCmdloop  ; Boucle si LCD busy
pop     ACC
mov     DPTR,#LcdCmdWriteAdd
movx    @DPTR,A     ; Ecriture de la commande a l'afficheur
ret

LcdReadStatus:
;
; Titre     :   Lecture du status de l'afficheur LCD
;               ------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Status dans le registre A
; Utilise   :   Registres DPH et DPL non sauvegardes
; Pile      :   2 avec l'appel
; Cycles    :   ?
;
LcdReadStatusLoop:
mov     DPTR,#LcdCmdReadAdd
movx    A,@DPTR     ; Lecture du status de l'afficheur
jb	ACC.7,LcdReadStatusLoop
ret

LcdWriteData:
;
; Titre     :   Ecriture d'une donnee a l'afficheur LCD
;               ---------------------------------------
;
; Entree(s) :   Donnee dans le registre A
; Sortie(s) :   Rien
; Utilise   :   Registre DPH et DPL non sauvegardes
; Pile      :   3 avec l'appel
; Cycles    :   ?
;
push    ACC
LcdWriteDataloop:
mov     DPTR,#LcdCmdReadAdd
movx    A,@DPTR     ; Lecture status de l'afficheur
jb	ACC.7,LcdWriteDataloop ; Boucle si LCD busy
pop     ACC
mov     DPTR,#LcdDataWriteAdd
movx    @DPTR,A     ; Ecriture de la donnee a l'afficheur
ret

LcdReposCurseur:
;
; Titre     :   Repositionnement du curseur a une position valide
;               -------------------------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien (curseur deplace si besoin)
; Utilise   :   Registres A, DPH et DPL non souvegarde
; Pile      :   5 avec l'appel
; Cycles    :   ?
;
lcall   LcdReadStatus
clr     C
subb    A,#10h
jc      LcdReposCurseurFin  ; Curseur entre 0 et 15 donc OK
subb    A,#30h
jc      LcdReposCurseur64   ; Curseur entre 16 et 63 donc recallage a 64
subb    A,#10h
jc      LcdReposCurseurFin  ; Curseur entre 64 et 79 donc OK
mov     A,#80h              ; Curseur > 80 donc recallage a 0
lcall   LcdWriteCmd
ret
LcdReposCurseur64:
mov     A,#0C0h
lcall   LcdWriteCmd
LcdReposCurseurFin:
ret
