; LIBLCDUS.ASM

;
;   Bibliotheque de sous-programmes utilisant l'afficheur LCD 2*16
;   --------------------------------------------------------------
;
;                      (C) E+E CHAMOUARD 2000
;

; A inclure dans le programme principal :
;   LibLcd.asm  pour les routines de commandes de l'afficheur LCD2*16
;               (donc definir LcdCmdReadAdd,..., inclure LibAsc.asm)
;   LibCla2.asm pour les routines d'entree du clavier ou bien definir des
;   routines specifiques pour l'application a savoir :
;       ClaRead : lecture a la volee du clavier avec une sortie dans A
;           0 si pas de touche
;           Tup, Tdown, Tleft, Tright et Tenter code des touches
;           Autre chose (si double touche par exemple)
;       ClaAntiRebond : assure la non prise en compte multiple des touches

LcdUsMenu4:
;
; Titre     :   Menu a 4 options standard
;               -------------------------
;
; Entree(s) :   Appeler avec un lcall LcdUsMenu4 juste avant une
;               liste de 4 options de menu :
;                   db "12345678",0,HIGH(Add),LOW(Add)
;               avec "12345678" etant le texte a afficher dans le menu et
;               Add l'adresse a executer si selection.
;               Les options sont dans l'ordre :
;                   haut a gauche
;                   haut a droite
;                   bas a gauche
;                   bas a droite
;               R2 permet de specifier l'option validee par defaut (0 a 3)
; Sortie(s) :   Rien (jump a l'adresse specifiee)
; Utilise   :   Registres A, R2, R3, R4, DPH et DPL non sauvegardes
; Pile      :   9 avec l'appel
; Cycles    :   ?
;
mov     A,R2
anl     A,#3
mov     R2,A
lcall   LcdRaz
pop     ACC
mov     R3,ACC
mov     DPH,ACC
pop     ACC
mov     R4,ACC
mov     DPL,ACC
lcall   LcdWriteStringCode      ; Affichage premiere option (haut a gauche)
mov     A,#8
lcall   LcdCurseur
mov     DPH,R3
mov     A,R4
add     A,#11
mov     DPL,A
mov     A,#0
addc    A,DPH
mov     DPH,A
lcall   LcdWriteStringCode      ; Affichage deuxieme option (haut a droite)
mov     A,#16
lcall   LcdCurseur
mov     DPH,R3
mov     A,R4
add     A,#22
mov     DPL,A
mov     A,#0
addc    A,DPH
mov     DPH,A
lcall   LcdWriteStringCode      ; Affichage troisieme option (bas a gauche)
mov     A,#24
lcall   LcdCurseur
mov     DPH,R3
mov     A,R4
add     A,#33
mov     DPL,A
mov     A,#0
addc    A,DPH
mov     DPH,A
lcall   LcdWriteStringCode      ; Affichage quatrieme option (bas a droite)
lcall   LcdCurseurOn
LcdUsMenu4Switch:
mov     A,R2
cjne    A,#0,LcdUsMenu4Switch1
mov     A,#0                    ; Position en haut a gauche
lcall   LcdCurseur
lcall   ClaAntiRebond
LcdUsMenu4Switch0_0:
lcall   ClaRead
cjne    A,#0,LcdUsMenu4Switch0_1
sjmp    LcdUsMenu4Switch0_0     ; 0 donc attente
LcdUsMenu4Switch0_1:
cjne    A,#Tdown,LcdUsMenu4Switch0_2
mov     R2,#2
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch0_2:
cjne    A,#Tright,LcdUsMenu4Switch0_3
mov     R2,#1
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch0_3:
cjne    A,#Tenter,LcdUsMenu4Switch0_4
ljmp    LcdUsMenu4Exit
LcdUsMenu4Switch0_4:
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch1:
cjne    A,#1,LcdUsMenu4Switch2
mov     A,#8                    ; Position en haut a droite
lcall   LcdCurseur
lcall   ClaAntiRebond
LcdUsMenu4Switch1_0:
lcall   ClaRead
cjne    A,#0,LcdUsMenu4Switch1_1
sjmp    LcdUsMenu4Switch1_0     ; 0 donc attente
LcdUsMenu4Switch1_1:
cjne    A,#Tdown,LcdUsMenu4Switch1_2
mov     R2,#3
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch1_2:
cjne    A,#Tleft,LcdUsMenu4Switch1_3
mov     R2,#0
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch1_3:
cjne    A,#Tenter,LcdUsMenu4Switch1_4
ljmp    LcdUsMenu4Exit
LcdUsMenu4Switch1_4:
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch2:
cjne    A,#2,LcdUsMenu4Switch3
mov     A,#16                   ; Position en bas a gauche
lcall   LcdCurseur
lcall   ClaAntiRebond
LcdUsMenu4Switch2_0:
lcall   ClaRead
cjne    A,#0,LcdUsMenu4Switch2_1
sjmp    LcdUsMenu4Switch2_0     ; 0 donc attente
LcdUsMenu4Switch2_1:
cjne    A,#Tup,LcdUsMenu4Switch2_2
mov     R2,#0
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch2_2:
cjne    A,#Tright,LcdUsMenu4Switch2_3
mov     R2,#3
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch2_3:
cjne    A,#Tenter,LcdUsMenu4Switch2_4
ljmp    LcdUsMenu4Exit
LcdUsMenu4Switch2_4:
sjmp    LcdUsMenu4Switch
LcdUsMenu4Switch3:
mov     A,#24                   ; Position en bas a droite
lcall   LcdCurseur
lcall   ClaAntiRebond
LcdUsMenu4Switch3_0:
lcall   ClaRead
cjne    A,#0,LcdUsMenu4Switch3_1
sjmp    LcdUsMenu4Switch3_0     ; 0 donc attente
LcdUsMenu4Switch3_1:
cjne    A,#Tup,LcdUsMenu4Switch3_2
mov     R2,#1
ljmp    LcdUsMenu4Switch
LcdUsMenu4Switch3_2:
cjne    A,#Tleft,LcdUsMenu4Switch3_3
mov     R2,#2
ljmp    LcdUsMenu4Switch
LcdUsMenu4Switch3_3:
cjne    A,#Tenter,LcdUsMenu4Switch3_4
ljmp    LcdUsMenu4Exit
LcdUsMenu4Switch3_4:
ljmp    LcdUsMenu4Switch
LcdUsMenu4Exit:                ; Recuperation de l'adresse et saut
mov     DPH,R3
mov     DPL,R4
mov     A,R2
anl     A,#3
mov     B,#11
mul     AB
add     A,#9
mov     B,A
movc    A,@A+DPTR
xch     A,B
inc     A
movc    A,@A+DPTR
mov     DPL,A
mov     DPH,B
mov     A,#0
jmp     @A+DPTR

LcdUsFlashMsg:
;
; Titre     :   Flash d'un message sur l'afficheur
;               ----------------------------------
;
; Entree(s) :   DPTR pointe sur le message a afficher
;               A donne le nombre de fois 20000 cycles a attendre
;                   apres affichage du message soit le nombre de
;                   fois 20 ms avec un processeur a 12 MHz
; Sortie(s) :   Rien (jump a l'adresse specifiee)
; Utilise   :   Registres A, PSW, B, DPH et DPL non sauvegardes
; Pile      :   11 avec l'appel
; Cycles    :   ?
;
mov     B,A
push    DPH
push    DPL
lcall   LcdHome
pop     DPL
pop     DPH
lcall   LcdWriteStringCode
LcdUsFlashMsgBoucle1:           ; 20000 cycles pour la boucle
mov     DPH,#20
LcdUsFlashMsgBoucle2:           ; 1000 cycles pour la boucle
mov     DPL,#100
LcdUsFlashMsgBoucle3:           ; 10 cycles pour la boucle
nop
nop
nop
nop
nop
nop
nop
nop
djnz    DPL,LcdUsFlashMsgBoucle3
djnz    DPH,LcdUsFlashMsgBoucle2
djnz    B,LcdUsFlashMsgBoucle1
ret
