; LIBSER.ASM
;
;        Librairie de sous programmes de conversion A/N pour  12F510
;
;                            (C) CHAMOUARD 2008
;                  (Libre de droits pour utilisation non 
;                   commerciale et  vos propres risques)

; Utilisation :
;	Cette bibliothque doit tre incluse dans le programme utilisateur
;	par une instruction #include "lib509\libadc.asc"
;	Comme les fonctions sont des sous-programmes, elles doivent tre incluse
;	dans la partie instructions du programme utilisateur

; 	Le programme doit initialiser le fonctionnement de l'ADC, par exemple
;    	movlw	b'11110001'
;		movwf	ADCON0
;		Ce qui :
;			- met sous tension l'ADC (bit 0  1)
;			- selectionne l'horloge sur INTOSC/4 (bits 4 et 5  1)
;			- selctionne les 4 entres analogiques (bits 6 et 7  1) 
;	puis lancer la conversion via une des commandes Adc_GetANx ou Adc_GetRef
;	le rsultat tant  lire dans le registre ADRES

;
; Titre     :   Conversion sur le canal AN0
;               ---------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Resultat dans ANRES
; Utilise   :   W, STATUS
; Pile      :   1
; Cycles    :   Dpend de la vitesse de la conversion
;
; Utilisation
;	...
;	call	Adc_GetAN0
;	...
;
Adc_GetAN0
	bcf		ADCON0,CHS0
	bcf		ADCON0,CHS1
	bsf		ADCON0,GO
Adc_GetAN0B1
	btfsc	ADCON0,NOT_DONE
	goto	Adc_GetAN0B1
	retlw	0

;
; Titre     :   Conversion sur le canal AN1
;               ---------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Resultat dans ANRES
; Utilise   :   W, STATUS
; Pile      :   1
; Cycles    :   Dpend de la vitesse de la conversion
;
; Utilisation
;	...
;	call	Adc_GetAN1
;	...
;
Adc_GetAN1
	bsf		ADCON0,CHS0
	bcf		ADCON0,CHS1
	bsf		ADCON0,GO
Adc_GetAN1B1
	btfsc	ADCON0,NOT_DONE
	goto	Adc_GetAN1B1
	retlw	0

;
; Titre     :   Conversion sur le canal AN2
;               ---------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Resultat dans ANRES
; Utilise   :   W, STATUS
; Pile      :   1
; Cycles    :   Dpend de la vitesse de la conversion
;
; Utilisation
;	...
;	call	Adc_GetAN2
;	...
;
Adc_GetAN2
	bcf		ADCON0,CHS0
	bsf		ADCON0,CHS1
	bsf		ADCON0,GO
Adc_GetAN2B1
	btfsc	ADCON0,NOT_DONE
	goto	Adc_GetAN2B1
	retlw	0

;
; Titre     :   Conversion sur le canal Ref
;               ---------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Resultat dans ANRES
; Utilise   :   W, STATUS
; Pile      :   1
; Cycles    :   Dpend de la vitesse de la conversion
;
; Utilisation
;	...
;	call	Adc_GetRef
;	...
;
Adc_GetRef
	bsf		ADCON0,CHS0
	bsf		ADCON0,CHS1
	bsf		ADCON0,GO
Adc_GetRefB1
	btfsc	ADCON0,NOT_DONE
	goto	Adc_GetRefB1
	retlw	0
