; LIBDIV.ASM
;
;               Librairie de sous programmes pour 12Fxxx
;
;                      (C) CHAMOUARD 2007-2008
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Utilisation :
;	Cette bibliothque doit tre incluse dans le programme utilisateur
;	par une instruction #include "lib509\libdiv.asc"
; 	Les fonctions sont implmentes dans des macro qu'il suffit
;	d'appeler avec la syntaxe standard de l'assembleur
;	L'entte de chaque fonction dcrit les paramtres et l'utilisation
;	de cette fonction spcifique

; Disponible et test (sur 12F509 sauf indication contraire) :
;	Scheduler
;		Module de syncronisation sur le TMR0 pour un dcompte prcis du temps
;		sur le 12Xxxx (qui ne dispose pas d'IT sur timer)
;	Dispatcher
;		Module de goto calcul
;	Table
;		Retourne une valeur d'une table
;	Debounce
;		Gestion d'un bouton place sur GP3 avec antirebond

;
; Titre     :   Scheduler utilisant TMR0
;               ------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien (reprise de l'execution juste aprs 
;				la transition TMR0 FF->0
; Utilise   :   W, STATUS
; Pile      :   0 (macro)
; Cycles    :   ?
;
; Utilisation
;	...
;	movlw	b'11010001'
;	option	; Clk=Osc/4, Prescaler sur TM0, Prescaler=4
;	...
;	Schedulerentry
;	Scheduler
;	...
;	goto Schedulerentry
;
;	1) Le programme initie le fonctionnement du TMR0
;	2) Le programme appelle Scheduler
;	3) Les parties utilisation font leur travail ds que TMR0
;	passe de FF  00 (qq instructions aprs) et retournent 
;	l'adresse Schedulerentry
;
;	Il faut videmment s'assurer que les tches lmentaires ne 
;	durent pas plus d'un cycle de TMR0 (ici environ 1 ms si 
;	Osc=4 MHz et comme TMR compte sur 8 bits) pour ne pas rater de cycle
;
Scheduler 	macro
Schedulerboucle1
	comf	TMR0,0
	btfss	STATUS,Z
	goto	Schedulerboucle1	; Retourne  Schedulerboucle1 si TMR0!=FF
Schedulerboucle2
	movf	TMR0,0
	btfss	STATUS,Z
	goto	Schedulerboucle2	; Retourne  Schedulerboucle2 si TMR0!=0
	endm

;
; Titre     :   Dispatcher
;               ----------
;
; Entree(s) :   Indice dans W
; Sortie(s) :   Execution transfre  l'adresse calcule
; Utilise   :   Rien (hors PCL)
; Pile      :   0 (macro)
; Cycles    :   3
;
; Utilisation
;	...
;		movf	Task,0		; L'indice est dans W
;		Dispatcher
;		goto	Task0
;		goto	Task1
;		goto	Task2
;	...
;
;	L'execution est transfre  l'adresse coorespondant au contenu
;	de W avant la ligne Dispatcher :
;		Task0 si W=0
;		Task1 si W=1
;		... 
;	La table doit tre dans la mme page (premire gnralement) de la memoire
;	programme (utilisation de la commande addwf PCL,1
;	Aucun controle n'est fait sur la validit de W
;
Dispatcher	macro
	addwf	PCL,1
	endm

;
; Titre     :   Table
;               -----
;
; Entree(s) :   Indice dans W
; Sortie(s) :   Retourne la Wime valeur de la table
; Utilise   :   Rien (hors PCL)
; Pile      :   1
; Cycles    :   3
;
; Utilisation
;	...
;	; Definition de la table
;		Table Label
;		retlw	Value0
;		retlw	Value1
;		retlw	Value2
;	...
;	; Utilisation de la table
;		movf	Task,0		; L'indice est dans W
;		call	Label
;	...
;
;	On retrouve alors dans W la valeur qui correspond  l'indice W
;		Value0 si W=0
;		Value1 si W=1
;		... 
;	La table doit tre dans la mme page (premire gnralement) de la memoire
;	programme (utilisation de la commande addwf PCL,1)
;	Aucun controle n'est fait sur la validit de W
;
Table	macro label
label	addwf	PCL,1
		endm

;
; Titre     :   Debounce
;               --------
;
; Entree(s) :   Rien
; Sortie(s) :   Registre DEBOUNCE mis  jour
; Utilise   :   
; Pile      :   0 (macro)
; Cycles    :   ?
;
; Utilisation
;	Ce programme assure la gestion de l'anti rebond d'un bouton 
;	branch sur GP3 et actif bas
;	Il met  jour le registre DEBOUNCE (qui doit tre dfini dans
;	le programme utilisateur), avec :
;		bit 0 ou BTN_O :   position instantane du bouton (1 pour bouton actif)
;		bit 1 ou BTN_OAR : position avec anti rebond (1 pour bouton actif)
;		bit 2 ou BTN_D :   le bouton vient d'tre appuy
;		bit 3 ou BTN_DAR : le bouton vient d'tre appuy avec anti rebond
;		bit 4 ou BTN_U :   le bouton vient d'tre relach
;		bit 5 ou BTN_UAR : l'antirebond vient de venir  chance
;	Il doit etre appel de manire rcurente, la dure de l'anti
;	rebond tant la priode de l'appel rcurent fois la valeur
;	DEBOUNCELEN (lui aussi devant tre defini par l'utilisateur)
;	Il utilise le registre DEBOUNCECNT pour compter le temps
;
;	Exemple
;		constant	DEBOUNCE=h'000d'	; Etat du bouton
;		constant	DEBOUNCECNT=h'000e'	; Compteur pour bouton
;		#define		DEBOUNCELEN h'FF'	; Dure de l'antirebond
;
;		movlw	0
;		movwf	DEBOUNCE				; Initialisation
;		...
;		Debounce						; Programme appel 
;		...
;
#define BTN_O	0
#define BTN_OAR 1
#define BTN_D	2
#define	BTN_DAR	3
#define	BTN_U	4
#define	BTN_UAR	5	
Debounce	macro
	bcf		DEBOUNCE,BTN_D			; Remise  0 des fonctions strobe
	bcf		DEBOUNCE,BTN_DAR
	bcf		DEBOUNCE,BTN_U
	bcf		DEBOUNCE,BTN_UAR
	movf	GPIO,0
	andlw	b'00001000'				; Extraction du bouton
	btfss	STATUS,Z
	goto	DebounceRel
	movlw	DEBOUNCELEN				; Bouton activ, armement du compteur d'anti rebond
	movwf	DEBOUNCECNT
	btfss	DEBOUNCE,BTN_O
	bsf		DEBOUNCE,BTN_D			; Bouton down si pas activ avant BTN_D
	bsf		DEBOUNCE,BTN_O			; Bouton actif BTN_O
	btfss	DEBOUNCE,BTN_OAR		; Si Bouton AR non activ
	bsf		DEBOUNCE,BTN_DAR		; Bouton down anti rebond BTN_DAR
	bsf		DEBOUNCE,BTN_OAR		; Activation du BTN_OAR
	goto	DebounceFin
DebounceRel							; Bouton relach
	btfsc	DEBOUNCE,BTN_O
	bsf		DEBOUNCE,BTN_U			; Bouton up si il tait actif avant
	bcf		DEBOUNCE,BTN_O			; Bouton BTN_O inactif
	btfss	DEBOUNCE,BTN_OAR
	goto	DebounceFin				; Rien de particulier si AR inactif
	decfsz	DEBOUNCECNT,1
	goto	DebounceFin				; Continue l'antirebond car pas encore 0
	bcf		DEBOUNCE,BTN_OAR		; BTN_OAR inactif car delai ecoul
	bsf		DEBOUNCE,BTN_UAR		; Up avec antirebond activ
DebounceFin
	endm
