; LIBSER.ASM
;
;        Librairie de sous programmes liaison serie pour 12Fxxx
;
;                         (C) CHAMOUARD 2008
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Utilisation :
;	Cette bibliothque doit tre incluse dans le programme utilisateur
;	par une instruction #include "lib509\libser.asc"
;	Comme les fonctions sont des sous-programmes, elles doivent tre incluse
;	dans la partie instructions du programme utilisateur
;	Le processeur doit tourner  4 MHz (horloge interne calibre avec le 
;	registre OSCAL.

; 	Le programme doit dfinir avec la directive #define (avant l'include) :
;		Ser_TxBit	Le bit du PIC pour la liaison srie (ex 0 pour GP0)
;		Ser_Speed	La vitesse de la liaison serie en bauds (ex 57600)
;		Ser_Bits	Le nombre de bits de la liaison serie (7 ou 8)
;		Ser_Pol		la polarit de la lisaison serie (1 pour Positive ou 0 pour Negative)
;			On utilise Positive quand le bit du PIC est directement branch sur la
;			liaison RS232 et Negative quand on passe par un MAX232
;	et les 3 registres de travail avec la commande constant (avant l'include) :
; 		Ser_TxBuff	Le buffer de transmission de la liaison
;		Ser_Dly		Le compteur d'attente de la liaison serie
;		Ser_Count	Le compteur des bits de la liaison serie
;		Ser_Tmp		Un registre de travail (utilis par Ser_SendByte)

; Disponible et test (sur 12F509 de 9600  57600 Bauds) :
;	Ser_Init
;		Initialisation de la liaison serie
;	Ser_SendChar
;		Envoi d'un caractre sur la liaison serie 7 ou 8 bits 2stops vitesse variable
;	Ser_SendHexa
;		Envoi d'un hexadecimal converti en ASCII sur la liaison srie
;	Ser_SendByte
;		Envoi d'un octet converti en 2 ASCII sur la liaison srie

; Constantes
	if Ser_Speed==9600
		#define Ser_cst	d'104'
	else 
		if Ser_Speed==19200
			#define Ser_cst d'52'
		else 
			if Ser_Speed==38400
				#define Ser_cst d'26'
			else 
				if Ser_Speed==57600
					#define Ser_cst d'18'
				else
					error "Non valid serial speed"
				endif
			endif
		endif
	endif

;
; Titre     :   Initialisation de la liaison serie
;               ----------------------------------
;
; Entree(s) :   Rien
; Sortie(s) :   Rien
; Utilise   :   W, STATUS, Ser_Dly
; Pile      :   1
; Cycles    :   Dure d'un mot complet (7 ou 8 bits + MARK + 2 STOPs)
;
; Utilisation
;	; Mettre en sortie le Bit de la liaison srie par une commande TRIS
;	movlw	b'11111111'
;	movwf	GPIO					; Tous les bits GPIO  1
;	movlw	b'11111110'
;	TRIS	GPIO					; GP0 en sortie, tous les autres en entre
;	...
;	call	Ser_Init
;	...
;
Ser_Init
	if Ser_Pol==1
		bcf		GPIO,Ser_TxBit
	else
		if Ser_Pol==0
			bsf		GPIO,Ser_TxBit
		else
			error "Non valid serial polarity"
		endif
	endif
	movlw	3*((Ser_cst)/4) ; Dure=(N*4+2) * 3s
	movwf	Ser_Dly
Ser_InitB1					; Boucle d'attente du start bit et des 2 stops
	nop
	decfsz	Ser_Dly,1
	goto	Ser_InitB1
	movlw	Ser_Bits*((Ser_cst)/4) ; Dure=(N*4+2) * (7 ou 8)s
	movwf	Ser_Dly
Ser_InitB2					; Boucle d'attente du reste d'un mot
	nop
	decfsz	Ser_Dly,1
	goto	Ser_InitB2
	retlw	0

;
; Titre     :   Envoi d'un caractre sur la liaison serie
;               -----------------------------------------
;
; Entree(s) :   Caractere  envoyer dans W
; Sortie(s) :   Rien
; Utilise   :   W, STATUS, Ser_Dly, Ser_Count, Ser_TxBuff 
; Pile      :   1
; Cycles    :   Dure d'un mot complet (7 ou 8 bits + MARK + 2 STOPs)
;
; Utilisation
;	...
;	call	Ser_Init
;	...
;	movlw	'H'
;	call	Ser_SendChar
;	...
;
;	La liaison envoie un caractre sur la liaison srie sur 8 bits,
;	avec 2stops pas de parit et une vitesse variable	
;
Ser_SendChar
	movwf	Ser_TxBuff		; Rangement du char  envoyer
	movlw	Ser_Bits		; Nombre de bits  traiter
	movwf	Ser_Count		; 8 bits  envoyer
	if Ser_Pol==1 
		bsf		GPIO,Ser_TxBit	; Dbut du start bit
	else          
		bcf		GPIO,Ser_TxBit	; Dbut du start bit
	endif
	nop
	nop
	nop
	movlw	(Ser_cst-d'14')/4 ; Dure=(N*4+14) * 1us
	movwf	Ser_Dly
Ser_SendCharB1				; Boucle d'attente du start bit
	nop
	decfsz	Ser_Dly,1
	goto	Ser_SendCharB1

Ser_SendCharB2				; Boucle sur les bits
	bcf		STATUS,C		; Clear de la carry
	rrf		Ser_TxBuff,1	; Rotation dans la carry, LSBd'abord
	btfsc	STATUS,C
	if Ser_Pol==1 			; Le bit est  1
		bcf		GPIO,Ser_TxBit	; Dbut du start bit
	else          
		bsf		GPIO,Ser_TxBit	; Dbut du start bit
	endif		
	btfss	STATUS,C
	if Ser_Pol==1 			; Le bit est  0
		bsf		GPIO,Ser_TxBit	; Dbut du start bit
	else          
		bcf		GPIO,Ser_TxBit	; Dbut du start bit
	endif
	nop
	nop
	movlw	(Ser_cst-d'14')/4 ; Dure=(N*4+14) * 1s
	movwf	Ser_Dly
Ser_SendCharB3				; Boucle d'attente du bit
	nop
	decfsz	Ser_Dly,1
	goto	Ser_SendCharB3
	nop
	nop
	decfsz	Ser_Count,1
	goto	Ser_SendCharB2

	nop
	nop
	nop
	nop
	if Ser_Pol==1 
		bcf		GPIO,Ser_TxBit	; Dbut du start bit
	else          
		bsf		GPIO,Ser_TxBit	; Dbut du start bit
	endif
	movlw	Ser_cst/2 		; Dure=(N*4+2) * 1 s
	movwf	Ser_Dly
Ser_SendCharB4				; Boucle d'attente des stop bits
	nop
	decfsz	Ser_Dly,1
	goto	Ser_SendCharB4
	retlw	0

;
; Titre     :   Envoi d'un hexa sur la liaison serie
;               ------------------------------------
;
; Entree(s) :   Hexa  envoyer dans W
; Sortie(s) :   Rien
; Utilise   :   W, STATUS, Ser_Dly, Ser_Count, Ser_TxBuff 
; Pile      :   1
; Cycles    :   Dure d'un mot complet (7 ou 8 bits + MARK + 2 STOPs)
;
; Utilisation
;	...
;	call	Ser_Init
;	...
;	movlw	0x03
;	call	Ser_SendChar
;	...
;
;	La liaison envoie le caractre reprsentant l'hexadecimal sur la liaison srie
;
Ser_SendHexa
	andlw	b'00001111'		; Au cas ou...
	movwf	Ser_TxBuff
	movlw	d'9'+1
	bcf		STATUS,C
	subwf	Ser_TxBuff,0
	btfss	STATUS,C
	goto	Ser_SendHexaFin
	movlw	'A'-d'10'		; Hexa ebtre A et F
	addwf	Ser_TxBuff,0
	goto	Ser_SendChar
Ser_SendHexaFin
	movlw	'0'				; Hexa entre 0 et 9
	addwf	Ser_TxBuff,0
	goto	Ser_SendChar	

;
; Titre     :   Envoi d'un byte sur la liaison serie en 2 ASCII
;               -----------------------------------------------
;
; Entree(s) :   Byte  envoyer dans W
; Sortie(s) :   Rien
; Utilise   :   W, STATUS, Ser_Dly, Ser_Count, Ser_TxBuff, Ser_Tmp
; Pile      :   2
; Cycles    :   Dure de mots complets (7 ou 8 bits + MARK + 2 STOPs)
;
; Utilisation
;	...
;	call	Ser_Init
;	...
;	movlw	0x13
;	call	Ser_SendByte
;	...
;
;	La liaison envoie le caractre reprsentant l'hexadecimal sur la liaison srie
;
Ser_SendByte
	movwf	Ser_Tmp
	swapf	Ser_Tmp,0
	call	Ser_SendHexa
	movf	Ser_Tmp,0
	goto	Ser_SendHexa
