// main.c

//-----------------------------------------------------------------------
//
//	Programme de test du PIC 18F4550 N 5: clignotement d'une led en C
//							avec programme compatible du bootloader
//                          et utilisation du timer 0 et des interruptions
//	---------------------------------------------------------------------
//
//	(C) 2008-2017 CHAMOUARD
//  (Libre de droits pour utilisation non 
//	commerciale et  vos propres risques)
//
//-----------------------------------------------------------------------


// Clignotement des LEDs sur le port RB
//
// Le circuit correspond au montage le plus simple pour le 18F4550 :
//	- quartz 20 MHz avec ses deux capacits de 10 pF
//	- _MCLR tire au +5V
//	- Alimentation et dcouplage de 100 nF et 47F
//	- 470 nF sur Vusb
//  - leds connectes au port B (voir plus bas)
// Le HID bootloader de Microchip est charg dans le PIC
// Le port B correspond  un compteur binaire (8 bits visibles si votre carte 
// le permet) qui bouge toutes les 90 ms environ. Le bit RB0 bouge donc avec une 
// frquence de 180 ms, le bit RB7  11 s, le tour complet tant fait en 22 s.
//
// Nouvelle version pour MPLAB.X, par rapport  la config par dfaut propose par 
//   MPLAB, il faut mettre 0x1000 dans le Codeoffset :
//     Properties, option du linker XC8, additional options

// Configuration des fusibles du PIC
// ---------------------------------
#pragma config PLLDIV   =5			// Quartz  20 MHz
#pragma config CPUDIV   =OSC1_PLL2   
#pragma config USBDIV   =2			// Clock = 96 MHz de la PLL /2
#pragma config FOSC     =HSPLL_HS
#pragma config FCMEN    =OFF
#pragma config IESO     =OFF
#pragma config PWRT     =OFF
#pragma config BOR      =ON
#pragma config BORV     =3
#pragma config VREGEN   =ON			//USB Voltage Regulator
#pragma config WDT      =OFF
#pragma config WDTPS    =32768
#pragma config MCLRE    =ON
#pragma config LPT1OSC  =OFF
#pragma config PBADEN   =OFF
//#pragma config CCP2MX   =ON
#pragma config STVREN   =ON
#pragma config LVP      =OFF
//#pragma config ICPRT    =OFF		// Dedicated In-Circuit Debug/Programming
#pragma config XINST    =OFF		// Extended Instruction Set
#pragma config CP0      =OFF
#pragma config CP1      =OFF
//#pragma config CP2      =OFF
//#pragma config CP3      =OFF
#pragma config CPB      =OFF
//#pragma config CPD      =OFF
#pragma config WRT0     =OFF
#pragma config WRT1     =OFF
//#pragma config WRT2     =OFF
//#pragma config WRT3     =OFF
#pragma config WRTB     =OFF		// Boot Block Write Protection
#pragma config WRTC     =OFF
//#pragma config WRTD     =OFF
#pragma config EBTR0    =OFF
#pragma config EBTR1    =OFF
//#pragma config EBTR2    =OFF
//#pragma config EBTR3    =OFF
#pragma config EBTRB    =OFF

#include <xc.h>

#define Contareload 160;
int Conta=Contareload;

void interrupt tc_clr(void) 
{
    if (TMR0IE && TMR0IF) 
    {
        Conta=Conta-1;
        TMR0IF=0;
        return;
    }
    // process any other high priority sources here
}

void main(void)
{
	TRISB=0b00000000;   // Ici les 8 bits visibles
    T0CON=0b11000110;   // TMR0=ON, Prescaler  128
    IPEN=0;             // Mode sans niveau d'interruptions
    TMR0IE=1;           // Active l'interruption du timer
    GIE=1;              // Activation des interruptions
	LATB=0;

	while(1)
	{
		if(Conta==0)
        {
            ++LATB;
            Conta=Contareload;
        }
	}
}


