; TEST01.ASM
;
;                 Programme de test du PIC12x509 N 1
;
;                        (C) CHAMOUARD 2006-2017
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Clignotement d'une LED avec oscilateur interne
;
; Le circuit utilise l'oscilateur interne  environ 4,0MHz 
;	(cycle d'instruction de 1 us environ).
; /MCLR est desactiv.
; Le port GPIO correspond  un compteur binaire le LSB (GP0 broche 7) commutant
; 	tous les 256*1024 cycles (environ) soit environ 250 ms et le MSB (GP5 broche 2)
;	tous les 256*1024*32 cycles (environ) soit environ 8 s. 
; On peut visualiser les commutations en reliant  la broche GPx une LED en 
; 	srie avec une resistance de 470 Ohm. Seule la sortie GP3 ne peut tre observe.

	list p=12f509, f=inhx8m

	#include "p12f509.inc"

	__config _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC

	constant	RFAST=H'0008'
	constant	RSLOW=H'0009'
	constant	RGPIO=H'000A'

	org		0
	goto	Debut

	org		10
Debut
	movlw	0
	movwf	GPIO
	movwf	RFAST
	movwf	RSLOW
	movwf	RGPIO
	TRIS	GPIO					; PortGPIO en sortie
	movlw	H'df'
	option							; Deactivation de l'entre TOCKI prioritaire sur TRIS

Boucle
	incf	RFAST, 1				; Increment registre RFAST
	btfss	STATUS, Z
	goto	Boucle
	incf	RSLOW, 1				; Increment registre RSLOW
	btfss	STATUS, Z
	goto	Boucle
	incf	RGPIO, 1				; Increment de la copie du registre GPIO
	movf	RGPIO, 0				; Copie de RGPIO dans W
	movwf	GPIO					; Copie de W dans GPIO
	goto	Boucle

	end

