; TEST02.ASM
;
;                 Programme de test du PIC12x509 N 2
;
;                        (C) CHAMOUARD 2008-2017
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Test des fonctions d'antirebond de la bibliotheque LIBDIV
;
; Le circuit utilise l'oscilateur interne  environ 4,0MHz 
;	(cycle d'instruction de 1 us environ).
; /MCLR est desactiv.
; Le bouton dont on teste l'antirebond est branche sur GP3 et est
; actif  l'tat bas
; Des leds branches sur les sorties GP0, GP1, GP2 et GP3 permettent de
; vrifier les sorties de la machine d'tat de l'antirebond
;	GP0 : sortie directe du bouton
;	GP1 : sortie avec antirebond
;	GP2 : sortie le bouton vient d'tre appuy avec antirebond
;	GP4 : sortie le bouton vient d'tre relach avec anti rebond
; Pour pouvoir visualiser les sorties, la machine tourne trs lentement,
; environ  64 ms, une utilisation relle la ferait tourner beaucoup 
; plus vite (1 ms par exemple)

	list p=12f509, f=inhx8m

	#include "p12f509.inc"

	#include "..\lib_509\libdiv.asm"

	__config _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC


	constant	DEBOUNCE=h'000d'	; Etat du bouton
	constant	DEBOUNCECNT=h'000e'	; Compteur pour bouton
	#define		DEBOUNCELEN h'40'	; Dure de l'antirebond ici ~4s

	org		0
	movwf	OSCCAL
Debut
	movlw	b'11111111'
	movwf	GPIO					; Tous les bits GPIO  1
	movlw	b'11001000'
	TRIS	GPIO					; PortGPIO en sortie sauf GP3
	movlw	b'11010111'
	option							; Clk=Osc/4, Prescaler sur TM0, Prescaler=256
	movlw	0
	movwf	TMR0
	movlw	0
	movwf	DEBOUNCE

Schedulerentry
	Scheduler						; Resynchronisation toute les 64 ms

	Debounce						; Antirebond du bouton
	
	movf	DEBOUNCE,0
	bsf		GPIO,0					; Extinction des leds
	bsf		GPIO,1
	bsf		GPIO,2
	bsf		GPIO,4
	btfsc	DEBOUNCE,BTN_O
	bcf		GPIO,0					; Led0=BTN_0
	btfsc	DEBOUNCE,BTN_OAR
	bcf		GPIO,1					; Led1=BTN_0AR
	btfsc	DEBOUNCE,BTN_DAR
	bcf		GPIO,2					; Led2=BTN_DAR
	btfsc	DEBOUNCE,BTN_UAR
	bcf		GPIO,4					; Led3=BTN_UAR
	goto	Schedulerentry

	end

