; TEST03.ASM
;
;                 Programme de test du PIC12x509 N 3
;
;                        (C) CHAMOUARD 2008-2017
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Test de la liaison serie en emission
;
; Le circuit utilise l'oscilateur interne  environ 4,0MHz 
;	(cycle d'instruction de 1 us environ).
; /MCLR est desactiv.
; La liaison serie est sur la sortie GP0 et le programme de test
; envoie indfiniment le message "Hello world, I'm PIC" suivi d'un
; CR+LF
; La liaison serie est sur 8 bits avec 2 bits de stop avec une vitesse
; paramtrable en logique positive soit avec le bit GP0 reli directement
; au signal RxD du PC (broche 2 de la prise DB9)
; Elle a t teste  9600, 19200, 38400 et 57600 bauds

	list p=12f509, f=inhx8m

	#include "p12f509.inc"

	__config _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC


	constant	Ser_Tmp		=0c		; Buffer temporaire
	constant	Ser_TxBuff	=0d		; Buffer d'emission de la liaison serie
	constant	Ser_Dly		=0e		; Compteur d'attente de la liaison serie
	constant	Ser_Count	=0f		; Compteur de bit de la liaison serie
	#define		Ser_TxBit	0		; Bit du PIC pour la liaison srie ici GP0
	#define		Ser_Speed	57600	; Vitesse de la liaison serie
	#define		Ser_Bits	8		; Nombre de bits de la liaison serie
	#define		Ser_Pol		1		; Polarit de la lisaison serie

	org		0
	movwf	OSCCAL					; Pour avoir la prcision voulue de la liaison
	
	goto	Debut

	#include "..\lib_509\libser.asm"

Debut
	movlw	b'11111111'
	movwf	GPIO					; Tous les bits GPIO  1
	movlw	b'11111110'
	TRIS	GPIO					; GP0 en sortie, tous les autres en entre

	call	Ser_Init				

Boucle
	movlw	'H'
	call	Ser_SendChar
	movlw	'e'
	call	Ser_SendChar
	movlw	'l'
	call	Ser_SendChar
	movlw	'l'
	call	Ser_SendChar
	movlw	'o'
	call	Ser_SendChar
	movlw	' '
	call	Ser_SendChar
	movlw	'w'
	call	Ser_SendChar
	movlw	'o'
	call	Ser_SendChar
	movlw	'r'
	call	Ser_SendChar
	movlw	'l'
	call	Ser_SendChar
	movlw	'd'
	call	Ser_SendChar
	movlw	','
	call	Ser_SendChar
	movlw	' '
	call	Ser_SendChar
	movlw	'I'
	call	Ser_SendChar
	movlw	'\''
	call	Ser_SendChar
	movlw	'm'
	call	Ser_SendChar
	movlw	' '
	call	Ser_SendChar
	movlw	'a'
	call	Ser_SendChar
	movlw	' '
	call	Ser_SendChar
	movlw	'P'
	call	Ser_SendChar
	movlw	'I'
	call	Ser_SendChar
	movlw	'C'
	call	Ser_SendChar
	movlw	0d
	call	Ser_SendChar
	movlw	0a
	call	Ser_SendChar
	goto	Boucle

	end

