; TEST04.ASM
;
;                 Programme de test du PIC12x510 N 4
;
;                        (C) CHAMOUARD 2008-2017
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Test des fonctions CAN via la liaison serie
;
; Le circuit utilise l'oscilateur interne  environ 4,0MHz 
;	(cycle d'instruction de 1 us environ).
; /MCLR est desactiv.
; La liaison serie est sur la sortie GP5 et le programme de test
; envoie indfiniment le message :
;	DATA_xx=aa,bb,cc,dd puis CR et LF
;	avec xx un compteur en hexa
;		 aa la valeur lue sur le canal AN0
;		 bb la valeur lue sur le canal AN1
;		 cc la valeur lue sur le canal AN2
;		 dd la valeur lue sur le canal Ref
; La liaison serie est sur 8 bits avec 2 bits de stop avec une vitesse
; de 57600 bauds et en logique positive (bit GP5 directement reli  
; la liaison srie

	list p=12f510, f=inhx8m

	#include "p12f510.inc"

	__config _IOSCFS_OFF & _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC


	constant	Dumb		=0b
	constant	Ser_Tmp		=0c		; Registre temporaire de la liaison serie
	constant	Ser_TxBuff	=0d		; Buffer d'emission de la liaison serie
	constant	Ser_Dly		=0e		; Compteur d'attente de la liaison serie
	constant	Ser_Count	=0f		; Compteur de bit de la liaison serie
	#define		Ser_TxBit	5		; Bit du PIC pour la liaison srie ici GP5
	#define		Ser_Speed	57600	; Vitesse de la liaison serie
	#define		Ser_Bits	8		; Nombre de bits de la liaison serie
	#define		Ser_Pol		1		; Polarit de la lisaison serie

	org		0
	movwf	OSCCAL					; Pour avoir la prcision voulue de la liaison
	
	goto	Debut

	#include "..\lib_509\libser.asm"
	#include "..\lib_509\libadc.asm"

Debut
	bcf		CM1CON0,3				; Arret du comparateur	 
    movlw	b'11110001'
	movwf	ADCON0					; ADC sur AN0, AN1 et AN2, CLK=INTOSC/4
	movlw	b'11111111'
	movwf	GPIO					; Tous les bits GPIO  1
	movlw	b'11011110'
	TRIS	GPIO					; GP5 en sortie, tous les autres en entre

	call	Ser_Init
	
	movlw	0xff
	movwf	Dumb		

Boucle
	movlw	'D'
	call	Ser_SendChar
	movlw	'A'
	call	Ser_SendChar
	movlw	'T'
	call	Ser_SendChar
	movlw	'A'
	call	Ser_SendChar
	movlw	'_'
	call	Ser_SendChar
	incf	Dumb,1
	movf	Dumb,0
	call	Ser_SendByte
	movlw	'='
	call	Ser_SendChar
	call	Adc_GetAN0
	movf	ADRES,0
	call	Ser_SendByte
	movlw	','
	call	Ser_SendChar
	call	Adc_GetAN1
	movf	ADRES,0
	call	Ser_SendByte
	movlw	','
	call	Ser_SendChar
	call	Adc_GetAN2
	movf	ADRES,0
	call	Ser_SendByte
	movlw	','
	call	Ser_SendChar
	call	Adc_GetRef
	movf	ADRES,0
	call	Ser_SendByte
	movlw	0d
	call	Ser_SendChar
	movlw	0a
	call	Ser_SendChar
	goto	Boucle

	end

