; TEST01.ASM
;
;                 Programme de test du PIC16x84 N 1
;
;                        (C) CHAMOUARD 2004
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Clignotement d'une LED avec oscilateur interne
;
; Le circuit utilise un oscilateur RC avec R=10kOhm et C=100pF ce qui fait une 
; 	frquence d'environ 0,7MHz (cycle d'instruction de 6 us environ).
; /MCLR est reli  VDD par une rsistance de 10 kOhm.
; Le port B correspond  un compteur binaire le LSB (RB0 broche 6) commutant
; 	tous les 1024 cycles (environ) soit environ 6 ms et le MSB (RB7 
;	broche 13) tous les 131000 cycles 'environ) soit environ 800 ms. 
; On peut visualiser les commutations en reliant  la broche RB7 une LED en 
; 	srie avec une resistance de 470 Ohm. On doit observer environ 40 cycles
;	allumage+extinction par minute (60 secondes / 6 us / 131000 / 2).

	list p=16f84, f=inhx8m

	__config _CP_OFF & _WDT_OFF & _PWRTE_ON & _RC_OSC

	#include "p16f84.inc"

	org		0
	goto	Debut

	org		10
Debut
	movlw	0
	movwf	PORTB
	bsf		STATUS, RP0
	movwf	TRISB					; PortB en sortie
	bcf		STATUS, RP0

Boucle
	addlw	1
	btfss	STATUS, Z
	goto	Boucle
	incf	PORTB, 1
	goto	Boucle

	end

