; TEST02.ASM
;
;                 Programme de test du PIC16x84 N 2
;
;                        (C) CHAMOUARD 2004
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Clignotement d'une LED par utilisation d'un timer
;
; Le circuit utilise un oscilateur RC avec R=10kOhm et C=100pF ce qui fait une 
; 	frquence d'environ 0,7MHz.
; /MCLR est reli  VDD par une rsistance de 10kOhm.
; Le port B correspond  un compteur binaire le LSB (RB0 broche 6) commutant
; 	toutes les 3ms (environ) et le MSB (RB7 broche 13) toutes les 400ms. 
; On peut visualiser les commutations en reliant  la broche RB7 une LED en 
; 	srie avec une resistance de 470Ohm. On doit observer environ 80 cycles
;	allumage+extinction par minute.

	list p=16f84, f=inhx8m

	__config _CP_OFF & _WDT_OFF & _PWRTE_ON & _RC_OSC

	#include "p16f84.inc"

TIME	equ	0x10

	org		0
	goto	Debut

	org     4
	goto    Interuption

	org		10
Debut
	movlw	0
    movwf	PORTB
	bsf		STATUS, RP0
	movwf	TRISB					; PortB en sortie
	movlw	B'00000000'
	movwf	OPTION_REG				; Pas de PullUp,TMR0 sur clock, prescaler=%2 (8 cycles)
	bcf		STATUS, RP0
	clrf	TMR0
	movlw	B'11111111'
	movwf	TIME					; Initialisation de l'heure
	movlw	B'10100000'
	movwf	INTCON					; TMR0+Global et rien d'autre

Boucle
	movf	TIME, W
	movwf	PORTB					; Mise  jour du port B	
	goto	Boucle

Interuption
	btfsc	INTCON, T0IF				; Interuption de TMR0 ?
	decf	TIME, 1					; Oui donc TIME=TIME-1
	clrf	INTCON					; Clear interuptions
	bsf		INTCON, T0IE				; Rearmement TMR0
	retfie							; Retour

	end

