; TEST03.ASM
;
;                 Programme de test du PIC16x84 N 3
;
;                        (C) CHAMOUARD 2004
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Clignotement d'une LED par utilisation du watchdog
;
; Le circuit utilise un oscilateur RC avec R=10kOhm et C=100pF ce qui fait une 
; 	frquence d'environ 0,7MHz.
; /MCLR est reli  VDD par une rsistance de 10kOhm.
; Le port B correspond  un compteur binaire le LSB (RB0 broche 6) commutant
; 	toutes les 18ms (environ) et le MSB (RB7 broche 13) toutes les 2300ms. 
; On peut visualiser les commutations en reliant  la broche RB7 une LED en 
; 	srie avec une resistance de 470Ohm. On doit observer environ 13 cycles
;	allumage+extinction par minute.

	list p=16f84,f=inhx8m

	__config _CP_OFF & _WDT_ON & _PWRTE_ON & _RC_OSC

	#include "p16f84.inc"

	org		0
	goto	Debut

	org		10
Debut
	movlw	0
	movwf	PORTB
	bsf		STATUS, RP0
	movwf	TRISB					; PortB en sortie
	movlw	B'00000000'
	movwf	OPTION_REG				; Pas de PullUp, prescaler=%1
	bcf		STATUS, RP0

Boucle
	sleep
	incf	PORTB,f
	goto	Boucle

	end
