// MyDialog.cpp

//-----------------------------------------------------------------------
//
//	Programme de test d'une interface USB HID
//
//	---------------------------------------------------------------------

#include "stdafx.h"
#include "MyDialog.h"
#include "resource.h"

#include <windows.h>
#include "setupapi.h"

//-----------------------------------------------------------------------------
//
// Interface HID
//
//-----------------------------------------------------------------------------

#define MY_DEVICE_ID  "vid_04d8&pid_003f"

HANDLE WriteHandle = INVALID_HANDLE_VALUE;
HANDLE ReadHandle  = INVALID_HANDLE_VALUE;

typedef HDEVINFO (WINAPI* DLL_SetupDiGetClassDevsUM)(
		LPGUID  ClassGuid,					//Input: Supply the class GUID here.
		LPCTSTR  Enumerator,				//Input: Use NULL here, not important for our purposes
		HWND  hwndParent,					//Input: Use NULL here, not important for our purposes
		DWORD  Flags);						//Input: Flags describing what kind of filtering to use.
DLL_SetupDiGetClassDevsUM SetupDiGetClassDevsUM;

typedef BOOL (WINAPI* DLL_SetupDiEnumDeviceInterfacesUM)(
		HDEVINFO  DeviceInfoSet,			//Input: Give it the HDEVINFO we got from SetupDiGetClassDevs()
		PSP_DEVINFO_DATA  DeviceInfoData,	//Input (optional)
		LPGUID  InterfaceClassGuid,			//Input
		DWORD  MemberIndex,					//Input: "Index" of the device you are interested in getting the path for.
		PSP_DEVICE_INTERFACE_DATA  DeviceInterfaceData);//Output: This function fills in an "SP_DEVICE_INTERFACE_DATA" structure.
DLL_SetupDiEnumDeviceInterfacesUM SetupDiEnumDeviceInterfacesUM;

typedef BOOL (WINAPI* DLL_SetupDiDestroyDeviceInfoListUM)(
		HDEVINFO  DeviceInfoSet);			//Input: Give it a handle to a device info list to deallocate from RAM.
DLL_SetupDiDestroyDeviceInfoListUM SetupDiDestroyDeviceInfoListUM;

typedef BOOL (WINAPI* DLL_SetupDiEnumDeviceInfoUM)(
		HDEVINFO  DeviceInfoSet,
		DWORD  MemberIndex,
		PSP_DEVINFO_DATA  DeviceInfoData);
DLL_SetupDiEnumDeviceInfoUM SetupDiEnumDeviceInfoUM;

typedef BOOL (WINAPI* DLL_SetupDiGetDeviceRegistryPropertyUM)(
		HDEVINFO  DeviceInfoSet,
		PSP_DEVINFO_DATA  DeviceInfoData,
		DWORD  Property,
		PDWORD  PropertyRegDataType,
		PBYTE  PropertyBuffer,
		DWORD  PropertyBufferSize,
		PDWORD  RequiredSize);
DLL_SetupDiGetDeviceRegistryPropertyUM SetupDiGetDeviceRegistryPropertyUM;

typedef BOOL (WINAPI* DLL_SetupDiGetDeviceInterfaceDetailUM)(
		HDEVINFO DeviceInfoSet,										//Input: Wants HDEVINFO which can be obtained from SetupDiGetClassDevs()
		PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData,				//Input: Pointer to an structure which defines the device interface.
		PSP_DEVICE_INTERFACE_DETAIL_DATA DeviceInterfaceDetailData,	//Output: Pointer to a strucutre, which will contain the device path.
		DWORD DeviceInterfaceDetailDataSize,						//Input: Number of bytes to retrieve.
		PDWORD RequiredSize,										//Output (optional): Te number of bytes needed to hold the entire struct
		PSP_DEVINFO_DATA DeviceInfoData);							//Output
DLL_SetupDiGetDeviceInterfaceDetailUM SetupDiGetDeviceInterfaceDetailUM;

int Connect()
//-----------------------------------------------------------------------
//
//	Initialisation et test de la carte INTER_CE
//
//	sortie 0 si le test est OK
//	-1 si l'interface n'est pas connecte
//	-3 si une des DLL n'a pas pu tre charge
//	-4 si erreur d'allocation mmoire
//	-5 si on n'a pas pu ouvrir un des handle d'criture/lecture
//
//-----------------------------------------------------------------------
{
	HMODULE m_hmodule;
	GUID InterfaceClassGuid = {0x4d1e55b2, 0xf16f, 0x11cf, 0x88, 0xcb, 0x00, 0x11, 0x11, 0x00, 0x00, 0x30};
	HDEVINFO DeviceInfoTable = INVALID_HANDLE_VALUE;
	PSP_DEVICE_INTERFACE_DATA InterfaceDataStructure = new SP_DEVICE_INTERFACE_DATA;
	PSP_DEVICE_INTERFACE_DETAIL_DATA DetailedInterfaceDataStructure = new SP_DEVICE_INTERFACE_DETAIL_DATA;
	DWORD InterfaceIndex = 0;
	SP_DEVINFO_DATA DevInfoData;
	DWORD dwRegType;
	DWORD dwRegSize;
	DWORD StructureSize = 0;
	DWORD ErrorStatus;
	PBYTE PropertyValueBuffer;
	char DeviceIDFromRegistry[128];

	// Chargement des differentes fonctions de la DLL
	m_hmodule=LoadLibrary("setupapi.dll");		// Chargement de la DLL
	if(m_hmodule==NULL)return(-3);

	SetupDiGetClassDevsUM=
		(DLL_SetupDiGetClassDevsUM)GetProcAddress(m_hmodule, "SetupDiGetClassDevsA");
	if(SetupDiGetClassDevsUM==NULL)return(-3);

	SetupDiEnumDeviceInterfacesUM=
		(DLL_SetupDiEnumDeviceInterfacesUM)GetProcAddress(m_hmodule, "SetupDiEnumDeviceInterfaces");
	if(SetupDiGetClassDevsUM==NULL)return(-3);

	SetupDiDestroyDeviceInfoListUM=
		(DLL_SetupDiDestroyDeviceInfoListUM)GetProcAddress(m_hmodule, "SetupDiDestroyDeviceInfoList");
	if(SetupDiGetClassDevsUM==NULL)return(-3);

	SetupDiEnumDeviceInfoUM=
		(DLL_SetupDiEnumDeviceInfoUM)GetProcAddress(m_hmodule, "SetupDiEnumDeviceInfo");
	if(SetupDiEnumDeviceInfoUM==NULL)return(-3);

	SetupDiGetDeviceRegistryPropertyUM=
		(DLL_SetupDiGetDeviceRegistryPropertyUM)GetProcAddress(m_hmodule, "SetupDiGetDeviceRegistryPropertyA");
	if(SetupDiGetDeviceRegistryPropertyUM==NULL)return(-3);

	SetupDiGetDeviceInterfaceDetailUM=
		(DLL_SetupDiGetDeviceInterfaceDetailUM)GetProcAddress(m_hmodule, "SetupDiGetDeviceInterfaceDetailA");
	if(SetupDiGetDeviceInterfaceDetailUM==NULL)return(-3);

	// Recherche de l'interface
	WriteHandle = INVALID_HANDLE_VALUE;
	ReadHandle  = INVALID_HANDLE_VALUE;

	// Remplit un tableau des periphriques connects de la bonne classe GUID
	DeviceInfoTable = SetupDiGetClassDevsUM(&InterfaceClassGuid, NULL, NULL, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);

	// Parcours de la liste pour trouver le bon
	while(true)
	{
		InterfaceDataStructure->cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
		if(SetupDiEnumDeviceInterfacesUM(DeviceInfoTable, NULL, &InterfaceClassGuid, InterfaceIndex, InterfaceDataStructure)
			==FALSE)
		{
			// Periphrique non trouv ou erreur
			SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);	//Clean up the old structure we no longer need.
			return(-1);
		}

		// Recuperation du hardware ID pour verifier le Vid, Pid

		// Initialisation de la structure SP_DEVINFO_DATA
		DevInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
		SetupDiEnumDeviceInfoUM(DeviceInfoTable, InterfaceIndex, &DevInfoData);

		// Rcupration de la taille du hardware ID
		SetupDiGetDeviceRegistryPropertyUM(DeviceInfoTable, &DevInfoData, SPDRP_HARDWAREID, &dwRegType, NULL, 0, &dwRegSize);

		// Rservation du buffer pour le hardware ID
		PropertyValueBuffer = (BYTE *) malloc (dwRegSize);
		if(PropertyValueBuffer == NULL)
		{
			// Pb mmoire
			SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);
			return(-4);
		}

		// Rcupration du hardware ID qui est sous la forme "Vid_04d8&Pid_003f" du permier buffer
		// qui est le "device ID"
		SetupDiGetDeviceRegistryPropertyUM(DeviceInfoTable, &DevInfoData, SPDRP_HARDWAREID, &dwRegType, PropertyValueBuffer, dwRegSize, NULL);

		// Vrification si c'est bien le peripherique recherch
		strcpy(DeviceIDFromRegistry, (char *)PropertyValueBuffer);
		// Passage en minuscule pour tre plus portable
		strlwr(DeviceIDFromRegistry);
		// Vrification du vid/Pid recherch
		DeviceIDFromRegistry[21]=0;

		if(strcmp(DeviceIDFromRegistry+4, MY_DEVICE_ID)==0)
		{
			// Le peripherique est trouve, on ouvre les fichers d'criture et de lecture
			DetailedInterfaceDataStructure->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
			// Premier appel pour avoir la valeur "StructureSize"
			SetupDiGetDeviceInterfaceDetailUM(DeviceInfoTable, InterfaceDataStructure, NULL, 0, &StructureSize, NULL);

			DetailedInterfaceDataStructure = (PSP_DEVICE_INTERFACE_DETAIL_DATA)(malloc(StructureSize));
			if(DetailedInterfaceDataStructure == NULL)
			{
				// Pb mmoire,
				SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);
				return(-4);
			}
			DetailedInterfaceDataStructure->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
			// Deuxime appel pour recevoir les donnes
			SetupDiGetDeviceInterfaceDetailUM(DeviceInfoTable, InterfaceDataStructure, DetailedInterfaceDataStructure, StructureSize, NULL, NULL);
			// Destruction de la table dont on n'a plus besoin
			SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);

			// Ouverture des handles pour communiquer
			WriteHandle = CreateFile((DetailedInterfaceDataStructure->DevicePath), GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
			ErrorStatus = GetLastError();
			if(ErrorStatus != ERROR_SUCCESS)return(-5);
			ReadHandle = CreateFile((DetailedInterfaceDataStructure->DevicePath), GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
			ErrorStatus = GetLastError();
			if(ErrorStatus != ERROR_SUCCESS)return(-5);

			return(0);
		}

		InterfaceIndex++;		// Peripherique suivant
	}
}

//-----------------------------------------------------------------------------
//
// Definitions for the CMyDialog class
//
//-----------------------------------------------------------------------------

CMyDialog::CMyDialog(UINT nResID) : CDialog(nResID)
{
}

CMyDialog::~CMyDialog()
{
}

BOOL CMyDialog::OnCommand(WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);

	switch (LOWORD(wParam))
    {
	case IDC_CONNECT:	    return OnConnect();
	case IDC_Reset:	        return OnReset();
	case IDC_Set:	        return OnSet();
	case IDC_Count:	        return OnCount();
	case IDC_GetState:	    return OnGetState();
	case IDM_FILE_QUIT:	    return OnQuit();
    }

	return FALSE;
}

BOOL CMyDialog::OnInitDialog()
{
	// Set the Icon
	SetIconLarge(IDW_MAIN);
	SetIconSmall(IDW_MAIN);

	// Associate the items with the controls
	AttachItem(IDC_Reset, m_Reset);
	AttachItem(IDC_Set, m_Set);
	AttachItem(IDC_Count, m_Count);
	AttachItem(IDC_GetState, m_GetState);
	AttachItem(IDC_STATIC1, m_Data);

	return true;
}

void CMyDialog::OnDestroy()
{
	// End the application
	::PostQuitMessage(0);
}

INT_PTR CMyDialog::DialogProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch(uMsg)
    {
    case WM_CLOSE:
        OnQuit();
        return TRUE;
    }

	// Pass unhandled messages on to parent DialogProc
	return DialogProcDefault(uMsg, wParam, lParam);
}

BOOL CMyDialog::OnAbout()
{
	MessageBox("HID Test\n(C) Eric CHAMOUARD 2009-2017", _T("About..."), MB_OK);
	return TRUE;
}

BOOL CMyDialog::OnConnect()
{
	//MessageBox(_T("Connect Button Pressed"), _T("Button"), MB_OK);
    if(Connect()==0)
    {
        m_Reset.EnableWindow(TRUE);
        m_Set.EnableWindow(TRUE);
        m_Count.EnableWindow(TRUE);
        m_GetState.EnableWindow(TRUE);
        m_Data.SetWindowText(_T("State : Unknown"));
        m_Data.EnableWindow(TRUE);
    }
    else
    {
        m_Reset.EnableWindow(FALSE);
        m_Set.EnableWindow(FALSE);
        m_Count.EnableWindow(FALSE);
        m_GetState.EnableWindow(FALSE);
        m_Data.SetWindowText(_T("State : Unknown"));
        m_Data.EnableWindow(FALSE);
    }
	return TRUE;
}

BOOL CMyDialog::OnReset()
{
	DWORD BytesWritten=0;
	unsigned char OutputPacketBuffer[65];	// Buffer pour le end point

	OutputPacketBuffer[0]=0;				// "Report ID"  0

	OutputPacketBuffer[1]=0x80;			    // Commande Reset

	WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	// Envoi de la commande

	return TRUE;
}

BOOL CMyDialog::OnSet()
{
	DWORD BytesWritten=0;
	unsigned char OutputPacketBuffer[65];	// Buffer pour le end point

	OutputPacketBuffer[0]=0;				// "Report ID"  0

	OutputPacketBuffer[1]=0x81;			    // Commande Set

	WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	// Envoi de la commande

	return TRUE;
}

BOOL CMyDialog::OnCount()
{
	DWORD BytesWritten=0;
	unsigned char OutputPacketBuffer[65];	// Buffer pour le end point

	OutputPacketBuffer[0]=0;				// "Report ID"  0

	OutputPacketBuffer[1]=0x82;			    // Commande Count

	WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	// Envoi de la commande

	return TRUE;
}

BOOL CMyDialog::OnGetState()
{
	DWORD BytesWritten=0;
	DWORD BytesRead=0;
	unsigned char OutputPacketBuffer[65];	// Buffer pour le end point
	unsigned char InputPacketBuffer[65];	// Buffer pour le end point

	InputPacketBuffer[0]=0;				    // "Report ID"  0
	OutputPacketBuffer[0]=0;				// "Report ID"  0
	OutputPacketBuffer[1]=0x90;			    // Commande GetState

	WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	// Envoi de la commande
	ReadFile(ReadHandle, &InputPacketBuffer, 65, &BytesRead, 0);		// Retour de la rponse

    switch(InputPacketBuffer[2])
    {
    case 0x00:
        m_Data.SetWindowText(_T("State: Not Pressed"));
        break;
    case 0x01:
        m_Data.SetWindowText(_T("State: SWO Pressed"));
        break;
    case 0x02:
        m_Data.SetWindowText(_T("State: SW1 Pressed"));
        break;
    case 0x03:
        m_Data.SetWindowText(_T("State: SWO and SW1 Pressed"));
        break;
    default:
        m_Data.SetWindowText(_T("State: Not Pressed"));
        break;
    }

	return TRUE;
}

BOOL CMyDialog::OnQuit()
{
	//MessageBox(_T("Quit Button Pressed.  Program will exit now."), _T("Button"), MB_OK);
	CDialog::OnOK();
	return TRUE;
}
