// Form1.h

//-----------------------------------------------------------------------
//
//	Programme de test d'une interface USB HID N1
//	A utiliser avec :
//	Programme de test du PIC 18F4550 N 6
//	---------------------------------------------------------------------
//
//	(C) 2008 CHAMOUARD
//  (Libre de droits pour utilisation non 
//	commerciale et  vos propres risques)
//
//-----------------------------------------------------------------------

#pragma once


//Includes
#include <Windows.h>
#include <setupapi.h>

#define MY_DEVICE_ID  "Vid_04d8&Pid_003F"	

namespace TstHid1 
{
	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Runtime::InteropServices;

	#ifdef UNICODE
	#define	Seeifdef	Unicode
	#else
	#define Seeifdef	Ansi
	#endif

	// Fonctions utilises pour l'interface HID

	[DllImport("setupapi.dll" , CharSet = CharSet::Seeifdef, EntryPoint="SetupDiGetClassDevs")]		
	extern "C" HDEVINFO  SetupDiGetClassDevsUM(
		LPGUID  ClassGuid,					//Input: Supply the class GUID here. 
		PCTSTR  Enumerator,					//Input: Use NULL here, not important for our purposes
		HWND  hwndParent,					//Input: Use NULL here, not important for our purposes
		DWORD  Flags);						//Input: Flags describing what kind of filtering to use.

	[DllImport("setupapi.dll" , CharSet = CharSet::Seeifdef, EntryPoint="SetupDiEnumDeviceInterfaces")]				
	extern "C" WINSETUPAPI BOOL WINAPI  SetupDiEnumDeviceInterfacesUM(
		HDEVINFO  DeviceInfoSet,			//Input: Give it the HDEVINFO we got from SetupDiGetClassDevs()
		PSP_DEVINFO_DATA  DeviceInfoData,	//Input (optional)
		LPGUID  InterfaceClassGuid,			//Input 
		DWORD  MemberIndex,					//Input: "Index" of the device you are interested in getting the path for.
		PSP_DEVICE_INTERFACE_DATA  DeviceInterfaceData);//Output: This function fills in an "SP_DEVICE_INTERFACE_DATA" structure.

	[DllImport("setupapi.dll" , CharSet = CharSet::Seeifdef, EntryPoint="SetupDiDestroyDeviceInfoList")]
	extern "C" WINSETUPAPI BOOL WINAPI  SetupDiDestroyDeviceInfoListUM(			
		HDEVINFO  DeviceInfoSet);			//Input: Give it a handle to a device info list to deallocate from RAM.

	[DllImport("setupapi.dll" , CharSet = CharSet::Seeifdef, EntryPoint="SetupDiEnumDeviceInfo")]
	extern "C" WINSETUPAPI BOOL WINAPI  SetupDiEnumDeviceInfoUM(
		HDEVINFO  DeviceInfoSet,
		DWORD  MemberIndex,
		PSP_DEVINFO_DATA  DeviceInfoData);

	[DllImport("setupapi.dll" , CharSet = CharSet::Seeifdef, EntryPoint="SetupDiGetDeviceRegistryProperty")]
	extern "C"	WINSETUPAPI BOOL WINAPI  SetupDiGetDeviceRegistryPropertyUM(
		HDEVINFO  DeviceInfoSet,
		PSP_DEVINFO_DATA  DeviceInfoData,
		DWORD  Property,
		PDWORD  PropertyRegDataType,
		PBYTE  PropertyBuffer,   
		DWORD  PropertyBufferSize,  
		PDWORD  RequiredSize);

	[DllImport("setupapi.dll" , CharSet = CharSet::Seeifdef, EntryPoint="SetupDiGetDeviceInterfaceDetail")]
	extern "C" BOOL SetupDiGetDeviceInterfaceDetailUM(
		HDEVINFO DeviceInfoSet,										//Input: Wants HDEVINFO which can be obtained from SetupDiGetClassDevs()
		PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData,				//Input: Pointer to an structure which defines the device interface.  
		PSP_DEVICE_INTERFACE_DETAIL_DATA DeviceInterfaceDetailData,	//Output: Pointer to a strucutre, which will contain the device path.
		DWORD DeviceInterfaceDetailDataSize,						//Input: Number of bytes to retrieve.
		PDWORD RequiredSize,										//Output (optional): Te number of bytes needed to hold the entire struct 
		PSP_DEVINFO_DATA DeviceInfoData);							//Output

	HANDLE WriteHandle = INVALID_HANDLE_VALUE;	//Need to get a write "handle" to our device before we can write to it.
	HANDLE ReadHandle = INVALID_HANDLE_VALUE;	//Need to get a read "handle" to our device before we can read from it.

	//-------------------------------------------------------------------------
	//
	// Declaration et code pour la fenetre principale du programme
	//
	//-------------------------------------------------------------------------

	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();
		}

	protected:
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::Button^  Connect_btn;
	private: System::Windows::Forms::Button^  ResetLEDs_btn;
	private: System::Windows::Forms::Button^  SetLEDs_btn;
	private: System::Windows::Forms::Button^  CountLEDs_btn;
	private: System::Windows::Forms::Button^  GetPushbuttonState_btn;
	private: System::Windows::Forms::Label^   StateLabel;

	private:
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code

		// Initialisations
		void InitializeComponent(void)
		{
			System::ComponentModel::ComponentResourceManager^  resources = (gcnew System::ComponentModel::ComponentResourceManager(Form1::typeid));
			this->Connect_btn = (gcnew System::Windows::Forms::Button());
			this->ResetLEDs_btn = (gcnew System::Windows::Forms::Button());
			this->SetLEDs_btn = (gcnew System::Windows::Forms::Button());
			this->CountLEDs_btn = (gcnew System::Windows::Forms::Button());
			this->GetPushbuttonState_btn = (gcnew System::Windows::Forms::Button());
			this->StateLabel = (gcnew System::Windows::Forms::Label());
			this->SuspendLayout();
			// 
			// Connect_btn
			// 
			this->Connect_btn->Location = System::Drawing::Point(13, 13);
			this->Connect_btn->Name = L"Connect_btn";
			this->Connect_btn->Size = System::Drawing::Size(75, 23);
			this->Connect_btn->TabIndex = 0;
			this->Connect_btn->Text = L"Connect";
			this->Connect_btn->UseVisualStyleBackColor = true;
			this->Connect_btn->Click += gcnew System::EventHandler(this, &Form1::Connect_btn_Click);
			// 
			// ResetLEDs_btn
			// 
			this->ResetLEDs_btn->Enabled = false;
			this->ResetLEDs_btn->Location = System::Drawing::Point(95, 13);
			this->ResetLEDs_btn->Name = L"ResetLEDs_btn";
			this->ResetLEDs_btn->Size = System::Drawing::Size(125, 23);
			this->ResetLEDs_btn->TabIndex = 1;
			this->ResetLEDs_btn->Text = L"Reset LEDs";
			this->ResetLEDs_btn->UseVisualStyleBackColor = true;
			this->ResetLEDs_btn->Click += gcnew System::EventHandler(this, &Form1::ResetLEDs_btn_Click);
			// 
			// SetLEDs_btn
			// 
			this->SetLEDs_btn->Enabled = false;
			this->SetLEDs_btn->Location = System::Drawing::Point(95, 42);
			this->SetLEDs_btn->Name = L"SetLEDs_btn";
			this->SetLEDs_btn->Size = System::Drawing::Size(126, 23);
			this->SetLEDs_btn->TabIndex = 2;
			this->SetLEDs_btn->Text = L"Set LEDs";
			this->SetLEDs_btn->UseVisualStyleBackColor = true;
			this->SetLEDs_btn->Click += gcnew System::EventHandler(this, &Form1::SetLEDs_btn_Click);
			// 
			// CountLEDs_btn
			// 
			this->CountLEDs_btn->Enabled = false;
			this->CountLEDs_btn->Location = System::Drawing::Point(95, 71);
			this->CountLEDs_btn->Name = L"CountLEDs_btn";
			this->CountLEDs_btn->Size = System::Drawing::Size(126, 23);
			this->CountLEDs_btn->TabIndex = 3;
			this->CountLEDs_btn->Text = L"Count LEDs";
			this->CountLEDs_btn->UseVisualStyleBackColor = true;
			this->CountLEDs_btn->Click += gcnew System::EventHandler(this, &Form1::CountLEDs_btn_Click);
			// 
			// GetPushbuttonState_btn
			// 
			this->GetPushbuttonState_btn->Enabled = false;
			this->GetPushbuttonState_btn->Location = System::Drawing::Point(96, 100);
			this->GetPushbuttonState_btn->Name = L"GetPushbuttonState_btn";
			this->GetPushbuttonState_btn->Size = System::Drawing::Size(125, 23);
			this->GetPushbuttonState_btn->TabIndex = 4;
			this->GetPushbuttonState_btn->Text = L"Get Pushbutton State";
			this->GetPushbuttonState_btn->UseVisualStyleBackColor = true;
			this->GetPushbuttonState_btn->Click += gcnew System::EventHandler(this, &Form1::GetPushbuttonState_btn_Click);
			// 
			// StateLabel
			// 
			this->StateLabel->AutoSize = true;
			this->StateLabel->Enabled = false;
			this->StateLabel->Location = System::Drawing::Point(227, 105);
			this->StateLabel->Name = L"StateLabel";
			this->StateLabel->Size = System::Drawing::Size(84, 13);
			this->StateLabel->TabIndex = 5;
			this->StateLabel->Text = L"State: Unknown";
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(400, 134);
			this->Controls->Add(this->CountLEDs_btn);
			this->Controls->Add(this->SetLEDs_btn);
			this->Controls->Add(this->StateLabel);
			this->Controls->Add(this->GetPushbuttonState_btn);
			this->Controls->Add(this->ResetLEDs_btn);
			this->Controls->Add(this->Connect_btn);
			this->Icon = (cli::safe_cast<System::Drawing::Icon^  >(resources->GetObject(L"$this.Icon")));
			this->Name = L"Form1";
			this->Text = L"HID TEST";
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion

		// Bouton connection
	private: System::Void Connect_btn_Click(System::Object^  sender, System::EventArgs^  e) 
		{
			//Globally Unique Identifier (GUID) for HID class devices.  Windows uses GUIDs to identify things.
			GUID InterfaceClassGuid = {0x4d1e55b2, 0xf16f, 0x11cf, 0x88, 0xcb, 0x00, 0x11, 0x11, 0x00, 0x00, 0x30}; 

			HDEVINFO DeviceInfoTable = INVALID_HANDLE_VALUE;
			PSP_DEVICE_INTERFACE_DATA InterfaceDataStructure = new SP_DEVICE_INTERFACE_DATA;
			PSP_DEVICE_INTERFACE_DETAIL_DATA DetailedInterfaceDataStructure = new SP_DEVICE_INTERFACE_DETAIL_DATA;
			SP_DEVINFO_DATA DevInfoData;

			DWORD InterfaceIndex = 0;
			DWORD StatusLastError = 0;
			DWORD dwRegType;
			DWORD dwRegSize;
			DWORD StructureSize = 0;
			PBYTE PropertyValueBuffer;
			bool MatchFound = false;
			DWORD ErrorStatus;

			String^ DeviceIDToFind = MY_DEVICE_ID;

			//First populate a list of plugged in devices (by specifying "DIGCF_PRESENT"), which are of the specified class GUID. 
			DeviceInfoTable = SetupDiGetClassDevsUM(&InterfaceClassGuid, NULL, NULL, DIGCF_PRESENT | DIGCF_DEVICEINTERFACE);

			//Now look through the list we just populated.  We are trying to see if any of them match our device. 
			while(true)
			{
				InterfaceDataStructure->cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
				SetupDiEnumDeviceInterfacesUM(DeviceInfoTable, NULL, &InterfaceClassGuid, InterfaceIndex, InterfaceDataStructure);
				ErrorStatus = GetLastError();
				if(ERROR_NO_MORE_ITEMS == GetLastError())	//Did we reach the end of the list of matching devices in the DeviceInfoTable?
				{	//Cound not find the device.  Must not have been attached.
					SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);	//Clean up the old structure we no longer need.
					return;		
				}

				//Now retrieve the hardware ID from the registry.  The hardware ID contains the VID and PID, which we will then 
				//check to see if it is the correct device or not.

				//Initialize an appropriate SP_DEVINFO_DATA structure.  We need this structure for SetupDiGetDeviceRegistryProperty().
				DevInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
				SetupDiEnumDeviceInfoUM(DeviceInfoTable, InterfaceIndex, &DevInfoData);

				//First query for the size of the hardware ID, so we can know how big a buffer to allocate for the data.
				SetupDiGetDeviceRegistryPropertyUM(DeviceInfoTable, &DevInfoData, SPDRP_HARDWAREID, &dwRegType, NULL, 0, &dwRegSize);

				//Allocate a buffer for the hardware ID.
				PropertyValueBuffer = (BYTE *) malloc (dwRegSize);
				if(PropertyValueBuffer == NULL)	//if null, error, couldn't allocate enough memory
				{	//Can't really recover from this situation, just exit instead.
					SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);	//Clean up the old structure we no longer need.
					return;		
				}

				//Retrieve the hardware IDs for the current device we are looking at.  PropertyValueBuffer gets filled with a 
				//REG_MULTI_SZ (array of null terminated strings).  To find a device, we only care about the very first string in the
				//buffer, which will be the "device ID".  The device ID is a string which contains the VID and PID, in the example 
				//format "Vid_04d8&Pid_003f".
				SetupDiGetDeviceRegistryPropertyUM(DeviceInfoTable, &DevInfoData, SPDRP_HARDWAREID, &dwRegType, PropertyValueBuffer, dwRegSize, NULL);

				//Now check if the first string in the hardware ID matches the device ID of my USB device.
				#ifdef UNICODE
				String^ DeviceIDFromRegistry = gcnew String((wchar_t *)PropertyValueBuffer);
				#else
				String^ DeviceIDFromRegistry = gcnew String((char *)PropertyValueBuffer);
				#endif
				//Convert both strings to lower case.  This makes the code more robust/portable accross OS Versions
				DeviceIDFromRegistry = DeviceIDFromRegistry->ToLowerInvariant();	
				DeviceIDToFind = DeviceIDToFind->ToLowerInvariant();				
				//Now check if the hardware ID we are looking at contains the correct VID/PID
				MatchFound = DeviceIDFromRegistry->Contains(DeviceIDToFind);		
				if(MatchFound == true)
				{
					//Device must have been found.  Open read and write handles.  In order to do this, we will need the actual device path first.
					//We can get the path by calling SetupDiGetDeviceInterfaceDetail(), however, we have to call this function twice:  The first
					//time to get the size of the required structure/buffer to hold the detailed interface data, then a second time to actually 
					//get the structure (after we have allocated enough memory for the structure.)
					DetailedInterfaceDataStructure->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
					//First call populates "StructureSize" with the correct value
					SetupDiGetDeviceInterfaceDetailUM(DeviceInfoTable, InterfaceDataStructure, NULL, NULL, &StructureSize, NULL);	
					DetailedInterfaceDataStructure = (PSP_DEVICE_INTERFACE_DETAIL_DATA)(malloc(StructureSize));		//Allocate enough memory
					if(DetailedInterfaceDataStructure == NULL)	//if null, error, couldn't allocate enough memory
					{	//Can't really recover from this situation, just exit instead.
						SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);	//Clean up the old structure we no longer need.
						return;		
					}
					DetailedInterfaceDataStructure->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
					 //Now call SetupDiGetDeviceInterfaceDetail() a second time to receive the goods.  
					SetupDiGetDeviceInterfaceDetailUM(DeviceInfoTable, InterfaceDataStructure, DetailedInterfaceDataStructure, StructureSize, NULL, NULL); 

					//We now have the proper device path, and we can finally open read and write handles to the device.
					//We store the handles in the global variables "WriteHandle" and "ReadHandle", which we will use later to actually communicate.
					WriteHandle = CreateFile((DetailedInterfaceDataStructure->DevicePath), GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);

					ErrorStatus = GetLastError();
					if(ErrorStatus == ERROR_SUCCESS)
					{
						ResetLEDs_btn->Enabled = true;				//Make button no longer greyed out
						SetLEDs_btn->Enabled = true;				//Make button no longer greyed out
						CountLEDs_btn->Enabled = true;				//Make button no longer greyed out
					}
					ReadHandle = CreateFile((DetailedInterfaceDataStructure->DevicePath), GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
					ErrorStatus = GetLastError();
					if(ErrorStatus == ERROR_SUCCESS)
					{
						GetPushbuttonState_btn->Enabled = true;		//Make button no longer greyed out
						StateLabel->Enabled = true;					//Make label no longer greyed out
					}
					SetupDiDestroyDeviceInfoListUM(DeviceInfoTable);	//Clean up the old structure we no longer need.
					return;
				}

				InterfaceIndex++;	
				//Keep looping until we either find a device with matching VID and PID, or until we run out of items.
			}//end of while(true)	
		}

		// Bouton reset des LEDs
	private: System::Void ResetLEDs_btn_Click(System::Object^  sender, System::EventArgs^  e) 
		{
			DWORD BytesWritten = 0;
			unsigned char OutputPacketBuffer[65];

			OutputPacketBuffer[0] = 0;		// Report ID
			OutputPacketBuffer[1] = 0x80;	// Reset LEDs commande

			WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	//Blocking function, unless an "overlapped" structure is used
		}

		// Bouton set des LEDs
	private: System::Void SetLEDs_btn_Click(System::Object^  sender, System::EventArgs^  e) 
		{
			DWORD BytesWritten = 0;
			unsigned char OutputPacketBuffer[65];

			OutputPacketBuffer[0] = 0;		// Report ID
			OutputPacketBuffer[1] = 0x81;	// Set LEDs commande

			WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	//Blocking function, unless an "overlapped" structure is used
		}

		// Bouton comptage des LEDs
	private: System::Void CountLEDs_btn_Click(System::Object^  sender, System::EventArgs^  e) 
		{
			DWORD BytesWritten = 0;
			unsigned char OutputPacketBuffer[65];

			OutputPacketBuffer[0] = 0;		// Report ID
			OutputPacketBuffer[1] = 0x82;	// Count LEDs commande

			WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	//Blocking function, unless an "overlapped" structure is used
		}

		// Bouton lecture des switchs
	private: System::Void GetPushbuttonState_btn_Click(System::Object^  sender, System::EventArgs^  e) 
		{
			DWORD BytesWritten = 0;
			DWORD BytesRead = 0;
			unsigned char OutputPacketBuffer[65];	//Allocate a memory buffer equal to our endpoint size + 1
			unsigned char InputPacketBuffer[65];	//Allocate a memory buffer equal to our endpoint size + 1

			InputPacketBuffer[0] = 0;				//The first byte is the "Report ID" and does not get transmitted over the USB bus.  Always set = 0.
			OutputPacketBuffer[0] = 0;				//The first byte is the "Report ID" and does not get transmitted over the USB bus.  Always set = 0.

			OutputPacketBuffer[1] = 0x90;			//0x90 is the "Get Pushbutton State" command in the firmware
													//For simplicity, we will leave the rest of the buffer uninitialized, but you could put real
													//data in it if you like.

			//The basic Windows I/O functions WriteFile() and ReadFile() can be used to read and write to HID class USB devices 
			//(once we have the read and write handles to the device, which are obtained with CreateFile()).

			//To get the pushbutton state, first, we send a packet with our "Get Pushbutton State" command in it.
			//The following call to WriteFile() sends 64 bytes of data to the USB device.
			WriteFile(WriteHandle, &OutputPacketBuffer, 65, &BytesWritten, 0);	//Blocking function, unless an "overlapped" structure is used
			//Now get the response packet from the firmware.
			//The following call to ReadFIle() retrieves 64 bytes of data from the USB device.
			ReadFile(ReadHandle, &InputPacketBuffer, 65, &BytesRead, 0);		//Blocking function, unless an "overlapped" structure is used	

			//InputPacketBuffer[0] is the report ID, which we don't care about.
			//InputPacketBuffer[1] is an echo back of the command.
			//InputPacketBuffer[2] contains the I/O port pin value for the pushbutton.  
			switch(InputPacketBuffer[2])
			{
			case 0x00:
				StateLabel->Text = "State: Not Pressed";
				break;
			case 0x01:
				StateLabel->Text = "State: SWO Pressed";
				break;
			case 0x02:
				StateLabel->Text = "State: SW1 Pressed";
				break;
			case 0x03:
				StateLabel->Text = "State: SWO and SW1 Pressed";
				break;
			default:
				StateLabel->Text = "State: Unknown";
				break;
			}
		}
	};
}
