// main.cpp

//-----------------------------------------------------------------------
//
//	Programme de test d'une interface USB HID
//
//	---------------------------------------------------------------------
//
//	A utiliser avec :
//	Programme Test06 charg dans un PIC18F4550
//
//	(C) 2009-2017 CHAMOUARD
//
//  (Libre de droits pour utilisation non
//	commerciale et  vos propres risques)
//
//-----------------------------------------------------------------------

// Historique :
//		Version 1.0 : version avec form sour Visual C++ Express 2008 et .NET
//      Version 2.0 : version GUI en Win32++

#include "stdafx.h"
#include "resource.h"

#include "MyDialog.h"


// Declaration of the CDialogApp class
class CDialogApp : public CWinApp
{
public:
	CDialogApp();
	virtual ~CDialogApp();
	virtual BOOL InitInstance();
	CMyDialog& GetDialog() {return m_MyDialog;}

private:
	CMyDialog m_MyDialog;
};

// returns a reference to the CDialogApp object
inline CDialogApp& GetDialogApp() { return static_cast<CDialogApp&>(GetApp()); }

// Definitions for the CDialogApp class
CDialogApp::CDialogApp() : m_MyDialog(IDD_DIALOG1)
{
}

BOOL CDialogApp::InitInstance()
{
	//Display the Modal Dialog
	m_MyDialog.DoModal();

	return TRUE;
}

CDialogApp::~CDialogApp()
{
}

int APIENTRY WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	try
	{
		// Start Win32++
		CDialogApp theApp;

		// Run the application
		return theApp.Run();
	}

	// catch all CException types
	catch (const CException &e)
	{
		// Display the exception and quit
		MessageBox(NULL, e.GetText(), AtoT(e.what()), MB_ICONERROR);

		return -1;
	}
}

