; preamp16.asm

;               Programme du pre-ampli version 1.6
;               ----------------------------------
;
;                   (C) E.CHAMOUARD 1991-2001
;              (Libre de droits pour utilisation non 
;               commerciale et  vos propres risques)

; Version transposee de celle de l'ancien assembleur 8085

; Version sans baxendal, ni volume, ni sauvegarde,
;   mais avec commande du volume, du baxendal et du
;   module fonction et utilisant le module de sortie
;   analogique.

label   cd8279, 4001h   ; Adresse commande du 8279
label   do8279, 4000h   ; Adresse donnees du 8279
label   admain, 2000h   ; Fonction de la sortie main 0 a 7
label   adaux,  2001h   ; Fonction de la sortie aux  0 a 7
label   adtb1,  2002h   ; Fonction de la sortie tb1  0 a 7
label   adtb2,  2003h   ; Fonction de la sortie tb2  0 a 7
label   adfon,  2004h   ; Fonction affichee 0=main, ff=aux
label   momain, 2005h   ; Mode de main               0 a 15
label   moaux,  2006h   ; Mode de aux                0 a 15
label   advol,  2007h   ; Volume du casque           0 a 99 (decim.)
label   adbass, 2008h   ; Niveau de basses           -8 a +7
label   admed,  2009h   ; Niveau de medium           -8 a +7
label   adtreb, 200ah   ; Niveau des aigus           -8 a +7
label   adana,  8000h   ; Adresse du module de sortie analogique

; Touches des claviers reliees au 8279
; ------------------------------------
;
; Touche        SCx     RLx     Code
;
; Pu1(in)       SC0     RL0     00h
; Pu2(in)       SC0     RL1     01h
; Tb1(in)       SC0     RL2     02h
; Tb2(in)       SC0     RL3     03h
; Cd1(in)       SC0     RL4     04h
; Cd2(in)       SC0     RL5     05h
; Tu(in)        SC0     RL6     06h
; Aux(in)       SC0     RL7     07h
;
; Main(out)     SC1     RL4     0ch
; Aux((out)     SC1     RL5     0dh
; Tb2(out)      SC1     RL6     0eh
; Tb1(out)      SC1     RL7     0fh
;
; -20dB         SC2     RL0     10h
; Loudness      SC2     RL1     11h
; Mute          SC2     RL2     12h
; Linear        SC2     RL3     13h
; Main/aux      SC2     RL4     14h
;
; Volume up     SC3     RL0     18h
; Volume down   SC3     RL1     19h
;
; Bass up       SC3     RL2     1ah
; Bass down     SC3     RL3     1bh
; Medium up     SC3     RL4     1ch
; Medium down   SC3     RL5     1dh
; Treble up     SC3     RL6     1eh
; Treble down   SC3     RL7     1fh

; Leds commandees par le 8279
; ---------------------------
;
; Led           CLx     LEDx
;
; Bass MSB      CL0     LED0 a LED6
; Bass LSB      CL1     LED0 a LED6
; Medium MSB    CL2     LED0 a LED6
; Medium LSB    CL3     LED0 a LED6
; Treble MSB    CL4     LED0 a LED6
; Treble LSB    CL5     LED0 a LED6
;
; Main (in)     CL8     LED0 a LED7 (dans l'ordre Pu1, PU2, Tb1, Tb2, Cd1, Cd2, Tu et Aux)
; Aux (in)      CL9     LED0 a LED7 (dans l'ordre Pu1, PU2, Tb1, Tb2, Cd1, Cd2, Tu et Aux)
; Tb1 (in)      CLa     LED0 a LED7 (dans l'ordre Pu1, PU2, Tb1, Tb2, Cd1, Cd2, Tu et Aux)
; Tb2 (in)      CLb     LED0 a LED7 (dans l'ordre Pu1, PU2, Tb1, Tb2, Cd1, Cd2, Tu et Aux)
;
; -20dB         CLc     LED0
; Loudness      CLc     LED1
; Mute          CLc     LED2
; Linear        CLc     LED3
; Main/aux      CLc     LED4
;
; Volume MSB    CLd     LED0 a LED7     Avec LED7 commandant le g du 3ieme afficheur
; Volume LSB    CLe     LED0 a LED6

; Cablage des afficheurs (! cablage non standard)
; -----------------------------------------------
;
;       a                  LED5
;     -----               ------
;  f |  g  | b      LED4 | LED6 | LED0
;     -----               ------
;  e |  d  | c      LED3 | LED2 | LED1
;     -----               ------

; Commandes des modules analogiques
; ---------------------------------
;
; Fonction      CMD     DATA        Code
;
; Main(in)      0h      0 a 7h       0 a  7h  } Avec data=x pour y :
; Aux(in)       1h      0 a 7h      10 a 17h  }
; Tb1(in)       2h      0 a 7h      20 a 27h  } 0=Pu1, 1=Pu2, 2=Tb1, 3=Tb2
; Tb2(in)       3h      0 a 7h      30 a 37h  } 4=Cd1, 5=Cd2, 6=Tu,  7=Aux
;
; Main(out)     4h      0 a 7h      40 a 47h  } Avec : data[0]=/-20dB (0 si -20dB est ON)
; Aux(out)      5h      0 a 7h      50 a 57h  } data[1]=/mute et data[2]=/linear

ORG     0h

debut:
di
lxi     sp,#2200h
jmp     ops
rst     7

Restart1:
di
jmp     debut
rst     7
rst     7
rst     7
rst     7

Restart2:
di
jmp     debut
rst     7
rst     7
rst     7
rst     7

Restart3:
di
jmp     debut
rst     7
rst     7
rst     7
rst     7

Restart4:
di
jmp     debut

Restart45:
di
jmp     debut

Restart5:
di
jmp     debut

Restart55:
di
jmp     debut

Restart6:
di
jmp     debut

Restart65:
di
jmp     debut

Restart7:
di
jmp     debut

Trap:
di
jmp     debut

inmc:               ; Init microprocesseur
xra     a
mov     b,a
mov     c,a
mov     d,a
mov     e,a
mov     h,a
mov     l,a
ret

dela:               ; Delai court (1 dans D = .02 ms)
push    psw
push    de
delas1:
dcx     de
nop
nop
nop
nop
mov     a,d
ora     e
jnz     delas1
pop     de
pop     psw
ret

inaf:               ; Initialisation du 8279
mvi     a,#08h      ; 16*8 bits
sta     cd8279      ; Encod 2key lock
mvi     a,#34h      ; Hclk = 2 MHz
sta     cd8279
ret

rcvo:               ; Retour de caractere a la volee
lda     cd8279      ; ff si rien dans la fifo
ani     #07h
jnz     rcvos2
mvi     a,#ffh      ; Rien dans la fifo
ret
rcvos2:             ; A carac dans la fifo
mvi     a,#50h
sta     cd8279
lda     do8279
ret

conv:               ; Decodage 3 bits A-A
ani     #07h        ; 02 -> 00000100
push    bc
mov     b,a
mvi     a,#80h
inr     b
convs3:
rlc
dcr     b
jnz     convs3
pop     bc
ret

c7seg:              ; Decodage pour afficheur 7 segments
push    hl          ; A-A de 0 a f
lxi     hl,#table
ani     #0fh
add     l
mov     l,a
mvi     a,#0
adc     h
mov     h,a
mov     a,m
pop     hl
ret
;
; Table de decodage pour les afficheurs 7 segments (X pour segment allume)
;
;   0     1     2     3     4     5     6     7
;
;  XX    --    XX    XX    --    XX    XX    XX
; X  X  |  X  |  X  |  X  X  X  X  |  X  |  |  X
;  --    --    XX    XX    XX    XX    XX    --
; X  X  |  X  X  |  |  X  |  X  |  X  X  X  |  X
;  XX    --    XX    XX    --    XX    XX    --
;
;   8     9     A     B     C     D     E     F
;
;  XX    XX    XX    --    XX    --    XX    XX
; X  X  X  X  X  X  X  |  X  |  |  X  X  |  X  |
;  XX    XX    XX    XX    --    XX    XX    XX
; X  X  |  X  X  X  X  X  X  |  X  X  X  |  X  |
;  XX    XX    --    XX    XX    XX    XX    --
;
table:
db      00111111b ; 0
db      00000011b ; 1
db      01101101b ; 2
db      01100111b ; 3
db      01010011b ; 4
db      01110110b ; 5
db      01111110b ; 6
db      00100011b ; 7
db      01111111b ; 8
db      01110111b ; 9
db      01111011b ; A
db      01011110b ; B
db      00111100b ; C
db      01001111b ; D
db      01111100b ; E
db      01111000b ; F

ops:                ; Partie operationnelle du programme
rim
ani     #80h
jz      test        ; Si l'entree SI est a 0 => test
call    inaf        ; Initialisation du 8279
mvi     a,#04h      ; Entree cd1
sta     admain      ; Sortie main
sta     adaux       ; Sortie aux
sta     adtb1       ; Sortie tb1
sta     adtb2       ; Sortie tb2
mvi     a,#0
sta     adfon       ; Fonction affichee = main
mvi     a,#09h
sta     momain      ; Main = linear, -20 dB
sta     moaux       ; Aux  = linear, -20 dB
mvi     a,#80
sta     advol       ; Volume = -80 dB
mvi     a,#0
sta     adbass      ; Basses  = 0
sta     admed       ; Mediums = 0
sta     adtreb      ; Aigus   = 0

prog:               ; Programmation de l'analogique et
lda     admain      ; correction des donnees
ani     #7
sta     admain      ; Main(in) corrige
ori     #0h
sta     adana       ; Main(in) programme

lda     adaux
ani     #7
sta     adaux       ; Aux(in) corrige
ori     #10h
sta     adana       ; Aux(in) programme

lda     adtb1
ani     #7
sta     adtb1       ; Tb1(in) corrige
ori     #20h
sta     adana       ; Tb1(in) programme

lda     adtb2
ani     #7
sta     adtb2       ; Tb2(in) corrige
ori     #30h
sta     adana       ; Tb2(in) programme

lda     adfon
ora     a
jz      progs10
mvi     a,#ffh
progs10:
sta     adfon       ; Octet fonction main/aux corrige

lda     momain
ani     #0fh
sta     momain      ; Fonction main corrige
mvi     b,#00h
ani     #08h        ; Extraction du bit linear
jnz     prog1suite1
mvi     b,#04h      ; Bit2 a 1 si linear=0
prog1suite1:
lda     momain
ani     #04h        ; Extraction du bit mute
jnz     prog1suite2
mov     a,b
adi     #02h
mov     b,a         ; Bit1 a 1 si mute=0
prog1suite2:
lda     momain
ani     #01h        ; Extraction du bit -20dB
jnz     prog1suite3
mov     a,b
adi     #01h
mov     b,a         ; Bit0 a 1 si -20dB=0
prog1suite3:
mov     a,b
ori     #40h
sta     adana       ; Fonction main programmee

lda     moaux
ani     #0fh
sta     moaux       ; Fonction aux corrigee
mvi     b,#00h
ani     #08h
jnz     prog2suite1
mvi     b,#04h
prog2suite1:
lda     moaux
ani     #04h
jnz     prog2suite2
mov     a,b
adi     #02h
mov     b,a
prog2suite2:
lda     moaux
ani     #01h
jnz     prog2suite3
mov     a,b
adi     #01h
mov     b,a
prog2suite3:
mov     a,b
ori     #50h
sta     adana       ; Fonction aux programmee

lda     advol
cpi     #100
jc      progs16
mvi     a,#99
progs16:
sta     advol       ; Volume corrige

lda     adbass
ani     #0fh
sta     adbass      ; Bass corrige

lda     admed
ani     #0fh
sta     admed       ; Medum corrige

lda     adtreb
ani     #0fh
sta     adtreb      ; Aigu corrige

affi:               ; Affichage des entrees
mvi     a,#98h
sta     cd8279
lda     admain
call    conv
sta     do8279
lda     adaux
call    conv
sta     do8279
lda     adtb1
call    conv
sta     do8279
lda     adtb2
call    conv
sta     do8279
lda     adfon       ; Affichage des fonctions
ora     a
jnz     affis8
lda     momain
ori     #10h
jmp     affis9
affis8:
lda     moaux
affis9:
sta     do8279
lda     advol       ; Affichage du volume
mov     b,a
mvi     e,#0
mvi     c,#0
affis20:
mov     a,b
cmp     e
jc      affis19     ; Saute si b<e
mov     a,e
adi     #10
mov     e,a
inr     c
jmp     affis20
affis19:
dcr     c
mov     a,c
ani     #0fh
mov     c,a
call    c7seg
ori     #80h
sta     do8279
mov     a,c
rlc
mov     c,a
rlc
rlc
add     c
mov     c,a
lda     advol
sub     c
ani     #0fh
call    c7seg
sta     do8279
mvi     a,#90h      ; Affichage de l'equalizer
sta     cd8279
lda     adbass      ; Affichage niveau des basses
ani     #8
jz      affis21
mvi     a,#40h
sta     do8279
lda     adbass
cma
ani     #7
inr     a
jmp     affis22
affis21:
mvi     a,#0
sta     do8279
lda     adbass
affis22:
call    c7seg
sta     do8279
lda     admed       ; Affichage niveau des mediums
ani     #8
jz      affis23
mvi     a,#40h
sta     do8279
lda     admed
cma
ani     #7
inr     a
jmp     affis24
affis23:
mvi     a,#0
sta     do8279
lda     admed
affis24:
call    c7seg
sta     do8279
lda     adtreb      ; Affichage niveau des aigus
ani     #8
jz      affis25
mvi     a,#40h
sta     do8279
lda     adtreb
cma
ani     #7
inr     a
jmp     affis26
affis25:
mvi     a,#0
sta     do8279
lda     adtreb
affis26:
call    c7seg
sta     do8279

caras4:             ; Boucle d'attente des caracteres
call    rcvo
cpi     #ffh
jz      caras4
carecu:             ; Caractere recu
ani     #3fh        ; Masque du shift et du control
cpi     #08h
jc      caras4      ; Caracteres non traites (tu, cd,...)
cpi     #0ch
jc      caras4      ; Caracteres non affectes
cpi     #10h
jc      caras11     ; Car = main, aux, tb1 ou tb2
cpi     #15h
jc      caras12     ; Car = module fonction
cpi     #18h
jc      caras4      ; Caracteres non affectes
cpi     #19h
jc      caras17     ; Volume up
cpi     #1ah
jc      caras18     ; Volume down
cpi     #1bh
jc      caras27     ; Bass up
cpi     #1ch
jc      caras28     ; Bass down
cpi     #1dh
jc      caras29     ; Medium up
cpi     #1eh
jc      caras30     ; Medium down
cpi     #1fh
jc      caras31     ; Treble up
cpi     #20h
jc      caras32     ; Treble down
jmp     caras4      ; Caracteres non affectes

caras11:            ; Car = main, aux, tb1 ou tb2
ani     #03h
mov     l,a
mvi     b,#20h
lxi     de,#10000   ; Clignot a 5 Hz
caras5:
mov     a,l
adi     #98h        ; Extinction
mov     h,a
sta     cd8279
mvi     a,#0
sta     do8279
call    dela
call    rcvo
cpi     #ffh
jnz     darecu
mov     a,h         ; Allumage
sta     cd8279
push    hl
mvi     h,#20h
mov     a,m
call    conv
sta     do8279
pop     hl
call    dela
call    rcvo
cpi     #ffh
jnz     darecu
dcr     b
jnz     caras5
jmp     affi        ; Retour car delai expire

darecu:             ; Caractere recu
push    psw
mov     a,h         ; Realumage
sta     cd8279
mvi     h,#20h
mov     a,m
call    conv
sta     do8279
pop     psw
ani     #3fh        ; Test du caractere
cpi     #08h
jnc     carecu      ; Carac non valide
mov     h,a
mov     a,l
cpi     #02h        ; Test si tb1
jnz     darecus6
mov     a,h
cpi     #02h
jz      affi        ; Retour car tb1in=tb1out
darecus6:
mov     a,l
cpi     #03h
jnz     darecus7
mov     a,h
cpi     #03h
jz      affi        ; Retour car tb2in=tb2out
darecus7:           ; Tout ok pour modif
mov     a,h
mvi     h,#20h
mov     m,a
jmp     prog

caras12:            ; Car = module fonction
cpi     #14h
jnz     caras13
lda     adfon       ; Traitement du main/aux
cma
sta     adfon
jmp     affi

caras13:            ; Traitement actions du module fonc
ani     #03h
call    conv
mov     h,a         ; Mise en forme de la commande
lda     adfon
ora     a
jnz     caras14
lda     momain      ; La commande affecte main
xra     h
sta     momain
jmp     prog
caras14:            ; La commande affecte aux
lda     moaux
xra     h
sta     moaux
jmp     prog

caras17:            ; Volume up
lda     advol
cpi     #0
jz      affi        ; Retour car vol=0
dcr     a
sta     advol
jmp     prog

caras18:            ; Volume down
lda     advol
inr     a
cpi     #100
jnc     affi        ; Retour car col>99
sta     advol
jmp     prog

caras27:            ; Bass up
lda     adbass
cpi     #7
jz      affi        ; Retour car bass=7
inr     a
ani     #0fh
sta     adbass
jmp     prog

caras28:            ; Bass down
lda     adbass
cpi     #8
jz      affi        ; Retour car bass=-8
dcr     a
ani     #0fh
sta     adbass
jmp     prog

caras29:            ; Medium up
lda     admed
cpi     #7
jz      affi        ; Retour car medium=7
inr     a
ani     #0fh
sta     admed
jmp     prog

caras30:            ; Medium down
lda     admed
cpi     #8
jz      affi        ; Retour car medium=-8
dcr     a
ani     #0fh
sta     admed
jmp     prog

caras31:            ; Treble up
lda     adtreb
cpi     #7
jz      affi        ; Retour car treble=7
inr     a
ani     #0fh
sta     adtreb
jmp     prog

caras32:            ; Treble down
lda     adtreb
cpi     #8
jz      affi        ; Retour car treble=-8
dcr     a
ani     #0fh
sta     adtreb
jmp     prog

test:               ; Partie test du programme
call    inaf
mvi     a,#01h
sta     2200h
mvi     a,#02h
sta     2201h
mvi     a,#04h
sta     2202h
mvi     a,#08h
sta     2203h
mvi     a,#09h
sta     2204h
mvi     a,#01h
sta     2205h
boucle:
mvi     a,#98h
sta     cd8279
lda     2200h
sta     do8279
lda     2201h
sta     do8279
lda     2202h
sta     do8279
lda     2203h
sta     do8279
lda     2204h
sta     do8279
lda     2205h
sta     do8279
sta     do8279
mvi     a,#90h
sta     cd8279
lda     2205h
sta     do8279
sta     do8279
sta     do8279
sta     do8279
sta     do8279
sta     do8279
lxi     de,#25000   ; Attente de 0,5 s
call    dela
lda     2200h
rlc
sta     2200h
lda     2201h
rlc
sta     2201h
lda     2202h
rlc
sta     2202h
lda     2203h
rlc
sta     2203h
lda     2204h
rlc
sta     2204h
lda     2205h
rlc
sta     2205h
call    rcvo
cpi     #ffh
jz      boucle      ; Boucle si pas de caractere
mvi     a,#0        ; Carac recu => mode test clavier
sta     admain
sta     adaux
sta     adtb1
mvi     a,#98h
sta     cd8279
mvi     a,#0
sta     do8279
sta     do8279
sta     do8279
sta     do8279
tests15:            ; Attente d'un caractere
call    rcvo
cpi     #ffh
jz      tests15
sta     adtb2       ; Affichage
mvi     a,#98h
sta     cd8279
lda     adtb2
sta     do8279
lda     admain
sta     do8279
lda     adaux
sta     do8279
lda     adtb1
sta     do8279
lda     adaux       ; Sauvegarde des anciennes donnees
sta     adtb1
lda     admain
sta     adaux
lda     adtb2
sta     admain
jmp     tests15
