; Thermo11.asm

; Programme du thermostat electronique V 1.1
; ------------------------------------------
;
;		(C) E+E CHAMOUARD 2001-2007
;    (Libre de droits pour utilisation non 
;     commerciale et  vos propres risques)
;
; Premiere version operationnelle
;	Thermostat simple avec :
;		- consigne reglable a chaud,
;		- hysteresis reglable,
;		- etalonnage reglable du capteur,
;		- sauvegarde complete (avec reprise en mode automatique si besoin).
;
; A faire pour les versions ulterieures :
;	Tests lors de la lecture de la sauvegarde ?
;	Programmation heure de variation de consigne ?
;	Options sur liaison serie ?
;	Options sur choix de l'algo du thermostat ?
;
; Materiel :
;	Bus I2C pour DS1621 et PCF8583
;	Commande ON/OFF chaufage actif bas
;	Afficheur LCD 2*16 et "clavier standard 2" sur extension
;
; Liaison serie pour monitoring :
;	7 bits
;	Parit paire
;	57600 bauds

;---------------------------------------------------------------------------
word	LcdCmdReadAdd,	#E002h
word	LcdCmdWriteAdd,	#E000h
word	LcdDataReadAdd,	#E003h
word	LcdDataWriteAdd,#E001h
;word	ClaAdd,			#E040h	; sur test
word	ClaAdd,			#E004h	; sur ops

byte	MsgFlash,		#100	; Soit 2 s (a 12 MHz) sur ops
;byte	MsgFlash,		#10		; Soit 0.2 s (a 12 MHz) sur test rapide

byte	ClaAntiRebonDly,#20		; Soit 20 ms (a 12 MHz) sur ops

bit		Relais,			P1.0

bit		I2CIT,			IT1
bit		I2CEX,			EX1
bit		I2CSCL,			P1.4
bit		I2CSDA,			P1.5

byte	I2CPCF8583Write,#010100000b
byte	I2CPCF8583Read,	#010100001b

byte	I2CDS1621Write,	#10010000b
byte	I2CDS1621Read,	#10010001b

byte	Tdown,			#01h
byte	Tleft,			#02h
byte	Tright,			#04h
byte	Tup,			#08h
byte	Tmenu,			#10h
byte	Tenter,			#20h

direct	RHS,			0Ah		; Registre pour les secondes			0 a 59 (en BCD)
direct	RHM,			0Bh		; Registre pour les minutes				0 a 59 (en BCD)
direct	RHH,			0Ch		; Registre pour les heures				0 a 23 (en BCD)
direct	RHJ,			0Dh		; Registre pour les jours (0=lundi)		0 a  6 (en BCD)
direct	RTH,			0Eh		; Registre pour les degres (degres en hexa)
direct	RTL,			0Fh		; Registre pour les fractions de degres (256emes de degre)

byte	RFirst,			#20h	; Adresse du premier registre a sauvegarder
byte	RNumber,		#10h	; Nombre de registres a sauvergarder

direct	CTH,			20h		; Registre pour la consigne (degres en hexa)
direct	CTL,			21h		; Registre pour les fractions de consigne (256emes de degre)
direct	CHH,			22h		; Registre pour l'hysteresis (degres en hexa)
direct	CHL,			23h		; Registre pour les fractions d'hysteresis (256emes de degre)
direct	DTH,			24h		; Registre pour etalonnage temperature (degres en hexa)
direct	DTL,			25h		; Registre pour etalonnage temperature (256emes de degre)
direct	RMO,			26h		; registre pour stockage du mode actuel (!=0 si automatique)

direct	TMP0,			30h		; Registre pour sauvegarde temporaire
direct	TMP1,			31h		; Registre pour sauvegarde temporaire

;---------------------------------------------------------------------------
ORG		0000h	; sur ops				; Reset externe
;ORG	2000h	; sur test				; Reset externe

INCLUDE lib\libint.asm

IE0Trt:							; Seule d'IT I2C sur IE1 est traite
TF0Trt:
TF1Trt:
RITITrt:
TF2EXF2Trt:
reti

;---------------------------------------------------------------------------
IE1Trt:							; Traitement de l'IT I2C
push	PSW
push	ACC
push	B
push	DPL
push	DPH

lcall	PCF8583ReadHeure
lcall	DS1621MesOK
jc		IE1Tempnomes			; Verifie si mesure prete
IE1Tempmes:
lcall	DS1621ReadTemp2			; Lecture de la temperature
add		A,DTL					; Correction par l'etalonnage
mov		RTL,A
mov		A,B
addc	A,DTH
mov		RTH,A
jnb		ACC.7,IE1TempmesS
mov		RTH,#0					; Saturation si temperature negative
mov		RTL,#0
IE1TempmesS:
lcall	DS1621Trigger			; Lance nouvelle mesure

IE1Tempnomes:
mov		A,RHS
jz		IE1Tempreport			; Reporting si secondes=00
clr		C
subb	A,#30h
jz		IE1Tempreport			; Reporting si secondes=30 (30h car codage en BCD)
IE1Exit:
pop		DPH
pop		DPL
pop		B
pop		ACC
pop		PSW
reti

IE1Tempreport:					; Reporting liaison serie
mov		A,RHJ
rl		A
rl		A
add		A,#LOW(Lun)
mov		DPL,A
mov		A,#0
addc	A,#HIGH(Lun)
mov		DPH,A
lcall	ComWriteStringCode		; Envoi jour
mov		A,#32
lcall	ComWriteChar
mov		A,RHH
lcall	ComWriteByteAscii		; Envoi heures
mov		A,#3Ah
lcall	ComWriteChar
mov		A,RHM
lcall	ComWriteByteAscii		; Envoi minutes
mov		A,#3Ah
lcall	ComWriteChar
mov		A,RHS
lcall	ComWriteByteAscii		; Envoi secondes
mov		A,#32
lcall	ComWriteChar
mov		A,RTH
mov		B,#10
div		AB
lcall	AscHexa2Car
lcall	ComWriteChar			; Envoi dizaines de degres
mov		A,B
lcall	AscHexa2Car
lcall	ComWriteChar			; Envoi degres
mov		A,#'.'
lcall	ComWriteChar
mov		A,RTL
lcall	ConvHexa2Deg
add		A,#'0'
lcall	ComWriteChar			; Envoi dixiemes de degres
mov		A,#32
lcall	ComWriteChar
mov		DPTR,#Onc
mov		C,Relais
jnc		IE1TrtSuite
mov		DPTR,#Off
IE1TrtSuite:
lcall	ComWriteStringCode		; Envoi On ou Off
mov		A,#13
lcall	ComWriteChar
mov		A,#10
lcall	ComWriteChar
pop		DPH
pop		DPL
pop		B
pop		ACC
pop		PSW
reti

;---------------------------------------------------------------------------
Begin:							; Initialisations
mov		SP,#7fh					; Debut de pile en 80h
setb	Relais					; Sortie off
lcall	LcdInit
lcall	LcdCurseurOff
lcall	I2CInit
mov		DPTR,#Help1				; Message d'acceuil N1
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
mov		DPTR,#Help2				; Message d'acceuil N2
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
mov		A,#ComSpeed_11_57600	; Initialisation liaison serie
lcall	ComInit
lcall	DS1621Init				; Init et trigger DS1621
lcall	DS1621Trigger
mov		RTH,#35					; Temperature defaut si init trop rapide
mov		RTL,#0
lcall	PCF8583Init				; Init PCF8583 et tentative de chargement configuration
lcall	PCF8583ReadProg			; Chargement du programme du PCF8583
jc		BootFroid				; Test si programme OK

BootChaud:						; Boot a chaud
mov		DPTR,#Help4
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	PCF8583ReadHeure		; Lecture de l'heure
setb	I2CIT					; It PCF8583
setb	I2CEX					; It externe 1 autorisee
setb	EA						; Interruptions enabelees
mov		A,RMO
jz		BootChaudSuite
ljmp	ModeAuto				; Mode auto si on y etait au shut off
BootChaudSuite:
ljmp	Menu1rst				; Menu 1 si on etait pas en en mode automatique

BootFroid:						; Boot a froid
mov		DPTR,#Help3
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
mov		RHJ,#0
mov		RHH,#0
mov		RHM,#0
mov		RHS,#0
lcall	PCF8583WriteHeure		; Stockage de l'heure dans le PCF
mov		CTH,#20					; 20 de consigne
mov		CTL,#0
mov		CHH,#1					; 1 d'hyteresis
mov		CHL,#0
mov		DTH,#feh				; Decalage de deux degres vers le bas
mov		DTL,#0
mov		RMO,#0					; Mode non automatique
lcall	PCF8583WriteProg
setb	I2CIT					; It PCF8583
setb	I2CEX					; It externe 1 autorisee
setb	EA						; Interruptions enabelees
ljmp	Menu1rst				; Menu 1 si boot a froid

;---------------------------------------------------------------------------
Menu1rst:						; Menu numero 1
mov		R2,#0
Menu1pre:						; Idem avec option preselectionnee
lcall	LcdCurseurOff
mov		DPTR,#MMenu1
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdUsMenu4
db		"Autom.  ",0,	HIGH(ModeAuto),			LOW(ModeAuto)
db		"Manuel  ",0,	HIGH(ModeManuel),		LOW(ModeManuel)
db		"Menu 2  ",0,	HIGH(Menu2rst),			LOW(Menu2rst)
db		"Menu 2  ",0,	HIGH(Menu2rst),			LOW(Menu2rst)

;---------------------------------------------------------------------------
Menu2rst:						; Menu numero 2
mov		R2,#0
Menu2pre:                       ; Idem avec option preselectionnee
lcall	LcdCurseurOff
mov		DPTR,#MMenu2
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdUsMenu4
db		"Heure   ",0,	HIGH(ModeHeure),		LOW(ModeHeure)
db		"Etalon. ",0,	HIGH(ModeEtalon),		LOW(ModeEtalon)
db		"Hyster. ",0,	HIGH(ModeHyster),		LOW(ModeHyster)
db		"Menu 1  ",0,	HIGH(Menu1rst),			LOW(Menu1rst)

;---------------------------------------------------------------------------
ModeManuel:						; Fonctionnement manuel
lcall	ClaAntiRebond			; ---------------------
lcall	LcdCurseurOff
mov		DPTR,#MManu1			; Affichage du message
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
mov		DPTR,#MManu2			; Affichage du message
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdRaz

ManuelBoucle:
lcall	LcdHome
lcall	AfficheHeure			; Affichage de l'heure
mov		A,#13
lcall	LcdCurseur
mov		DPTR,#On
mov		C,Relais
jnc		ManuelSuite1
mov		DPTR,#Off
ManuelSuite1:
lcall	LcdWriteStringCode		; Affichage On ou Off
mov		A,#16
lcall	LcdCurseur
mov		DPTR,#MTemp
lcall	LcdWriteStringCode		; Affichage "T="
mov		B,RTH
mov		A,RTL
lcall	AfficheTemp				; Affichage temperature
mov		A,#26
lcall	LcdCurseur
mov		DPTR,#MManu3
lcall	LcdWriteStringCode		; Affichage "Manuel"
lcall	ClaRead					; Test si touche tapee
cjne	A,#0,ManuelSuite2
ljmp	ManuelBoucle

ManuelSuite2:
cjne	A,#Tmenu,ManuelSuite3	; Test si la touche est menu
setb	Relais					; Chauffage off si sortie du mode
ljmp	Menu1rst				; Retour au menu

ManuelSuite3:
cjne	A,#Tup,ManuelSuite4		; Test si la touche est up
clr		Relais
ljmp	ManuelSuiteFin

ManuelSuite4:
cjne	A,#Tdown,ManuelSuiteFin	;Test si la touche est down
setb	Relais

ManuelSuiteFin:
lcall	ClaAntiRebond			; Touche non traitee ou fin traitement
ljmp	ManuelBoucle

;---------------------------------------------------------------------------
ModeAuto:						; Fonctionnement thermostat automatique
lcall	ClaAntiRebond			; -------------------------------------
lcall	LcdCurseurOff
mov		DPTR,#MAuto1			; Affichage du message
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
mov		DPTR,#MAuto2			; Affichage du message
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdRaz
mov		RMO,#1
ljmp	AutoStock				; Sauvegarde dans le PCF8583 du mode actuel

AutoBoucle:
clr		EA						; Thermostat simple avec hysteresis
mov		DPH,RTH
mov		DPL,RTL
setb	EA						; Registre de temperature capture dans DPTR
clr		C
mov		A,DPL					; Soustraction de la consigne  la temprature
subb	A,CTL
mov		DPL,A
mov		A,DPH
subb	A,CTH
mov		DPH,A
jc		AutoSuite5				; C=1 si T<TC
clr		C
mov		A,DPL
subb	A,CHL
mov		A,DPH
subb	A,CHH
jc		AutoSuite6				; C=1 si  T<TC+Hysteresis
setb	Relais					; Off chauffage car T>=TC+TH
ljmp	AutoSuite6
AutoSuite5:						; On chauffage car T<TC
clr		Relais

AutoSuite6:
lcall	LcdHome					; Affichage des informations
lcall	AfficheHeure			; Affichage de l'heure
mov		A,#13
lcall	LcdCurseur
mov		DPTR,#On
mov		C,Relais
jnc		AutoSuite1
mov		DPTR,#Off
AutoSuite1:
lcall	LcdWriteStringCode		; Affichage On ou Off
mov		A,#16
lcall	LcdCurseur
mov		DPTR,#MTemp
lcall	LcdWriteStringCode		; Affichage "T="
mov		B,RTH
mov		A,RTL
lcall	AfficheTemp				; Affichage temperature
mov		A,#25
lcall	LcdCurseur
mov		DPTR,#MCons
lcall	LcdWriteStringCode		; Affichage "C="
mov		B,CTH
mov		A,CTL
lcall	AfficheTemp				; Affichage consigne

lcall   ClaRead                 ; Test si touche tapee
cjne    A,#0,AutoSuite2
ljmp    AutoBoucle

AutoSuite2:
cjne	A,#Tmenu,AutoSuite3		; Test si la touche est menu
setb	Relais					; Chauffage off si sortie du mode
mov		RMO,#0
clr		EA
lcall	PCF8583WriteProg		; Sauvegarde dans le PCF l'information de sortie du mode
setb	EA
ljmp	Menu1rst				; Retour au menu

AutoSuite3:
cjne	A,#Tup,AutoSuite4		; Test si la touche est up
mov		A,CTL					; Incrementation de la consigne
lcall	ConvHexa2Deg			; Recuperation des dixiemes de degres
cjne	A,#9,AutoUp1
AutoUp1:
jc		AutoUp2					; Inferieur a 10 ?
mov		CTL,#0					; Incrementation CTH et CTL
inc		CTH
ljmp	AutoUp3
AutoUp2:						; Incrementation CTL uniquement
inc		A
lcall	ConvDeg2Hexa
mov		CTL,A
AutoUp3:						; Verification non depassement de 24.9
mov		A,CTL
lcall	ConvHexa2Deg
clr		C
subb	A,#0
mov		A,CTH
subb	A,#25
jc		AutoUp4
mov		A,#9					; Saturation a +24.9
lcall	ConvDeg2Hexa
mov		CTL,A
mov		CTH,#24
AutoUp4:
ljmp	AutoStock

AutoSuite4:
cjne	A,#Tdown,AutoSuiteFin	;Test si la touche est down
mov		A,CTL					; Decrementation de la consigne
lcall	ConvHexa2Deg			; Recuperation des dixiemes de degres
jnz		AutoDown1				; 0 ?
mov		A,#9					; Decrementation CHH et CHL
lcall	ConvDeg2Hexa
mov		CTL,A
dec		CTH
ljmp	AutoDown3
AutoDown1:						; Decrementation CHL uniquement
dec		A
lcall	ConvDeg2Hexa
mov		CTL,A
AutoDown3:						; Verification non depassement de 5.0
mov		A,CTL
lcall	ConvHexa2Deg
clr		C
subb	A,#0
mov		A,CTH
subb	A,#5
jnc		AutoDown4
mov		CTL,#0
mov		CTH,#5
AutoDown4:
AutoStock:						; Stockage dans le PCF8583 de la nouvelle consigne
clr		EA
lcall	PCF8583WriteProg
setb	EA

AutoSuiteFin:
lcall	ClaAntiRebond			; Touche non traitee ou fin traitement
ljmp	AutoBoucle

;---------------------------------------------------------------------------
ModeHeure:						; Reglage de l'heure
lcall	ClaAntiRebond			; ------------------
lcall	LcdCurseurOff
mov		DPTR,#MHeur1			; Affichage du message
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdRaz
lcall	LcdCurseurOn
mov		DPTR,#MHeur2
lcall	LcdWriteStringCode
clr		EA						; Arret de la mise a jour par le PCF
nop
lcall	PCF8583ReadHeure
mov		RHS,#0					; Reset des secondes

HeureJour:						; Position Jour
lcall	ClaAntiRebond			; -------------
lcall	LcdHome
lcall	AfficheHeure
mov		A,#0
lcall	LcdCurseur
Heure00:
lcall	ClaRead
lcall	JmpTable
db		HIGH(Heure00),		LOW(Heure00),		0		; Pas de touche
db		HIGH(HeureExit),	LOW(HeureExit),		Tenter	; Sortie sur validation
db		HIGH(HeureCancel),	LOW(HeureCancel),	Tmenu	; Sortie sur cancel
db		HIGH(Heure02),		LOW(Heure02),		Tup		; Jour up
db		HIGH(Heure01),		LOW(Heure01),		Tdown	; Jour down
db		HIGH(HeureHeure),	LOW(HeureHeure),	Tright	; Heure
db		HIGH(HeureJour),	LOW(HeureJour),		Tleft	; Rien
db		0,0,	HIGH(HeureJour),	LOW(HeureJour)		; Defaut

Heure01:						; Decrementation du jour
dec		RHJ
mov		A,RHJ
clr		C
subb	A,#7
jc		HeureJour
mov		RHJ,#6
ljmp	HeureJour
Heure02:						; Incrementation du jour
inc		RHJ
mov		A,RHJ
clr		C
subb	A,#7
jc		HeureJour
mov		RHJ,#0
ljmp	HeureJour

HeureHeure:						; Position Heure
lcall	ClaAntiRebond			; --------------
lcall	LcdHome
lcall	AfficheHeure
mov		A,#5
lcall	LcdCurseur
Heure10:
lcall	ClaRead
lcall	JmpTable
db		HIGH(Heure10),		LOW(Heure10),		0		; Pas de touche
db		HIGH(HeureExit),	LOW(HeureExit),		Tenter	; Sortie sur validation
db		HIGH(HeureCancel),	LOW(HeureCancel),	Tmenu	; Sortie sur cancel
db		HIGH(Heure12),		LOW(Heure12),		Tup		; Heure up
db		HIGH(Heure11),		LOW(Heure11),		Tdown	; Heure down
db		HIGH(HeureMinute),	LOW(HeureMinute),	Tright	; Minute
db		HIGH(HeureJour),	LOW(HeureJour),		Tleft	; Jour
db		0,0,	HIGH(HeureHeure),	LOW(HeureHeure)		; Defaut

Heure11:						; Decrementation de l'heure
mov		A,RHH
add		A,#99h
da		A
mov		RHH,A
clr		C
subb	A,#24h
jc		HeureHeure
mov		RHH,#23h
ljmp	HeureHeure
Heure12:						; Incrementation de l'heure
mov		A,RHH
add		A,#01h
da		A
mov		RHH,A
clr		C
subb	A,#24h
jc		HeureHeure
mov		RHH,#0
ljmp	HeureHeure

HeureMinute:					; Position Minute
lcall	ClaAntiRebond			; ---------------
lcall	LcdHome
lcall	AfficheHeure
mov		A,#8
lcall	LcdCurseur
Heure20:
lcall	ClaRead
lcall	JmpTable
db		HIGH(Heure20),		LOW(Heure20),		0		; Pas de touche
db		HIGH(HeureExit),	LOW(HeureExit),		Tenter	; Sortie sur validation
db		HIGH(HeureCancel),	LOW(HeureCancel),	Tmenu	; Sortie sur cancel
db		HIGH(Heure22),		LOW(Heure22),		Tup		; Minute up
db		HIGH(Heure21),		LOW(Heure21),		Tdown	; Minute down
db		HIGH(HeureMinute),	LOW(HeureMinute),	Tright	; Rien
db		HIGH(HeureHeure),	LOW(HeureHeure),	Tleft	; Minute
db		0,0,	HIGH(HeureMinute),	LOW(HeureMinute)	; Defaut

Heure21:						; Decrementation de la minute
mov		A,RHM
add		A,#99h
da		A
mov		RHM,A
clr		C
subb	A,#60h
jc		HeureMinute
mov		RHM,#59h
ljmp	HeureMinute
Heure22:						; Incrementation de la minute
mov		A,RHM
add		A,#01h
da		A
mov		RHM,A
clr		C
subb	A,#60h
jc		HeureMinute
mov		RHM,#0h
ljmp	HeureMinute

HeureExit:						; Sortie sur validation (enter)
lcall	PCF8583WriteHeure		; Stockage de l'heure dans le PCF
nop
setb	EA						; Interruption enabelees
ljmp	Menu2rst

HeureCancel:					; Sortie sur annulation (cancel)
nop
setb	EA
ljmp	Menu2rst

;---------------------------------------------------------------------------
ModeEtalon:						; Reglage de l'etalonnage temperature
lcall	ClaAntiRebond			; -----------------------------------
lcall	LcdCurseurOff
mov		DPTR,#MEtal1
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdRaz
lcall	LcdCurseurOn
mov		DPTR,#MEtal2
lcall	LcdWriteStringCode
push	DTH
push	DTL						; Sauvegarde valeurs anterieures (si cancel)

Etal:							; Affichage principal etalonnage
lcall	ClaAntiRebond			; ------------------------------
Etal00:
mov		A,#3
lcall	LcdCurseur
mov		B,RTH
mov		A,RTL
lcall	AfficheTemp				; Affichage temperature
mov		A,#11
lcall	LcdCurseur
mov		B,DTH
mov		A,DTL
lcall	AfficheDeca				; Affichage decalage
mov		A,#14
lcall	LcdCurseur
mov		A,#50
lcall	Ret2ms
lcall	ClaRead
lcall	JmpTable
db		HIGH(Etal00),		LOW(Etal00),		0		; Pas de touche
db		HIGH(EtalExit),		LOW(EtalExit),		Tenter	; Sortie sur validation
db		HIGH(EtalCancel),	LOW(EtalCancel),	Tmenu	; Sortie sur cancel
db		HIGH(Etal02),		LOW(Etal02),		Tup		; Etal up
db		HIGH(Etal01),		LOW(Etal01),		Tdown	; Etal down
db		HIGH(Etal),			LOW(Etal),			Tright	; Rien
db		HIGH(Etal),			LOW(Etal),			Tleft	; Rien
db		0,0,	HIGH(Etal),			LOW(Etal)			; Defaut

Etal02:							; Incrementation de l'etalonnage
mov		A,DTL
lcall	ConvHexa2Deg			; Recuperation des dixiemes de degres
cjne	A,#9,Etal02S1
Etal02S1:
jc		Etal02S2				; Inferieur a 9 ?
mov		TMP1,DTH				; Incrementation DTH et DTL
inc		TMP1
mov		TMP0,#0
ljmp	Etal02S3
Etal02S2:
inc		A
lcall	ConvDeg2Hexa
mov		TMP0,A
mov		TMP1,DTH
Etal02S3:						; Verification non depassement de +9.9
mov		A,TMP1
jb		ACC.7,Etal02S4			; Forcement Ok si nombre negatif
mov		A,TMP0
lcall	ConvHexa2Deg
clr		C
subb	A,#0
mov		A,TMP1
subb	A,#10
jc		Etal02S4				; Ok car inferieur a +10.0
mov		A,#9
lcall	ConvDeg2Hexa
mov		TMP0,A
mov		TMP1,#9
Etal02S4:
clr		EA
mov		DTH,TMP1
mov		DTL,TMP0
setb	EA
ljmp	Etal

Etal01:							; Decrementation de l'etalonnage
mov		A,DTL
lcall	ConvHexa2Deg			; Recuperation des dixiemes de degres
cjne	A,#0,Etal01S2
mov		TMP1,DTH				; Decrementation DTH et DTL
dec		TMP1
mov		A,#9
lcall	ConvDeg2Hexa
mov		TMP0,A
ljmp	Etal01S3
Etal01S2:						; Decrementation DTL uniquement
dec		A
lcall	ConvDeg2Hexa
mov		TMP0,A
mov		TMP1,DTH
Etal01S3:						; Verification non depassement de -9.9
mov		A,TMP1
jnc		Etal01S4				; Forcement Ok si nombre positif
mov		A,TMP0
lcall	ConvHexa2Deg
clr		C
subb	A,#1
mov		A,TMP1
subb	A,#F6h
jnb		ACC.7,Etal01S4
mov		A,#1
lcall	ConvDeg2Hexa
mov		TMP0,A
mov		TMP1,#F6h
Etal01S4:
clr		EA
mov		DTH,TMP1
mov		DTL,TMP0
setb	EA
ljmp	Etal

EtalExit:						; Sortie sur validation (enter)
pop		ACC
pop		ACC
clr		EA
lcall	PCF8583WriteProg
setb	EA
ljmp	Menu2rst

EtalCancel:						; Sortie sur annulation (cancel)
pop		DTL
pop		DTH
ljmp	Menu2rst

;---------------------------------------------------------------------------
ModeHyster:						; Reglage de l'hysteresis
lcall	ClaAntiRebond			; -----------------------
lcall	LcdCurseurOff
mov		DPTR,#MHyst1
mov		A,#MsgFlash
lcall	LcdUsFlashMsg
lcall	LcdRaz
lcall	LcdCurseurOn
mov		DPTR,#MHyst2
lcall	LcdWriteStringCode
push	CHH
push	CHL						; Sauvegarde valeurs anterieures (si cancel)

Hyst:							; Affichage principal etalonnage
lcall	ClaAntiRebond			; ------------------------------
mov		A,#9
lcall	LcdCurseur
mov		B,CHH
mov		A,CHL
lcall	AfficheDeca				; Affichage hysteresis
mov		A,#12
lcall	LcdCurseur
Hyst00:
lcall	ClaRead
lcall	JmpTable
db		HIGH(Hyst00),		LOW(Hyst00),		0		; Pas de touche
db		HIGH(HystExit),		LOW(HystExit),		Tenter	; Sortie sur validation
db		HIGH(HystCancel),	LOW(HystCancel),	Tmenu	; Sortie sur cancel
db		HIGH(Hyst02),		LOW(Hyst02),		Tup		; Hyst up
db		HIGH(Hyst01),		LOW(Hyst01),		Tdown	; Hyst down
db		HIGH(Hyst),			LOW(Hyst),			Tright	; Rien
db		HIGH(Hyst),			LOW(Hyst),			Tleft	; Rien
db		0,0,	HIGH(Hyst),			LOW(Hyst)			; Defaut

Hyst02:							; Incrementation de l'hysteresis
mov		A,CHL
lcall	ConvHexa2Deg			; Recuperation des dixiemes de degres
cjne	A,#9,Hyst02S1
Hyst02S1:
jc		Hyst02S2				; Inferieur a 9 ?
mov		CHL,#0					; Incrementation CHH et CHL
inc		CHH
ljmp	Hyst02S3
Hyst02S2:						; Incrementation CHL uniquement
inc		A
lcall	ConvDeg2Hexa
mov		CHL,A
Hyst02S3:						; Verification non depassement de 9.9
mov		A,CHL
lcall	ConvHexa2Deg
clr		C
subb	A,#0
mov		A,CHH
subb	A,#10
jc		Hyst02S4
mov		A,#9                    ; Saturation a +9.9
lcall	ConvDeg2Hexa
mov		CHL,A
mov		CHH,#9
Hyst02S4:
ljmp	Hyst

Hyst01:							; Decrementation de l'hysteresis
mov		A,CHL
lcall	ConvHexa2Deg			; Recuperation des dixiemes de degres
jnz		Hyst01S1				; 0 ?
mov		A,#9					; Decrementation CHH et CHL
lcall	ConvDeg2Hexa
mov		CHL,A
dec		CHH
ljmp	Hyst01S3
Hyst01S1:						; Decrementation CHL uniquement
dec		A
lcall	ConvDeg2Hexa
mov		CHL,A
Hyst01S3:						; Verification non depassement de 0.2
mov		A,CHL
lcall	ConvHexa2Deg
clr		C
subb	A,#2
mov		A,CHH
subb	A,#0
jnc		Hyst01S4
mov		A,#2
lcall	ConvDeg2Hexa
mov		CHL,A
mov		CHH,#0
Hyst01S4:
ljmp	Hyst

HystExit:						; Sortie sur validation (enter)
pop		ACC
pop		ACC
clr		EA
lcall	PCF8583WriteProg
setb	EA
ljmp	Menu2rst

HystCancel:						; Sortie sur annulation (cancel)
pop		CHL
pop		CHH
ljmp	Menu2rst

;---------------------------------------------------------------------------
Lun:	db	"Lun",0
Mar:	db	"Mar",0
Mer:	db	"Mer",0
Jeu:	db	"Jeu",0
Ven:	db	"Ven",0
Sam:	db	"Sam",0
Dim:	db	"Dim",0
On:		db	" On",0
Onc:	db	"On",0
Off:	db	"Off",0

;			"0123456789abcdef0123456789abcdef",0
Help1:	db	"   Thermostat     electronique  ",0
Help2:	db	"  Version 1.0   (C) E.CHAMOUARD ",0
Help3:	db	"Pas de programme  Boot a froid  ",0
Help4:	db	"  Programme OK    Boot a chaud  ",0

MMenu1:	db	"      Menu          Numero 1    ",0
MMenu2:	db	"      Menu          Numero 2    ",0
MMenu3:	db	"      Menu          Numero 3    ",0

MManu1:	db	"   Mode manuel  Menu pour sortir",0
MManu2:	db	"  Up ou down => On/Off chauffage",0
MManu3:	db	"Manuel",0

MTemp:	db	"T=",0
MCons:	db	"C=",0

MAuto1:	db	"Mode automatiqueMenu pour sortir",0
MAuto2:	db	"  Up ou down => Change consigne ",0

MHeur1:	db	"  Reglage heure  Enter ou Cancel",0
MHeur2:	db	"xxx 00:00:00     Enter ou Cancel",0

MEtal1:	db	"  Etalon. Temp.  Enter ou Cancel",0
MEtal2:	db	" T=xx.xz D=yx.xz Enter ou Cancel",0

MHyst1:	db	" Reglage Hyster. Enter ou Cancel",0
MHyst2:	db	"  Hyster=yx.xz   Enter ou Cancel",0

PCF8583ProgEntete:
db		"ThermV10",0

AfficheTemp:					; Affichage d'une temperature
push	ACC						; ---------------------------
mov		A,B						; Temperature dans {B,A}
lcall	LcdWrite2Dec			; Affichage sous la forme 25.3
mov		A,#'.'
lcall	LcdWriteChar
pop		ACC
lcall	ConvHexa2Deg
add		A,#'0'
lcall	LcdWriteChar
mov		A,#DFh
lcall	LcdWriteChar
ret

ConvDeg2Hexa:					; Conversion dixiemes de degres vers hexa
cjne	A,#10,ConvDeg2Hexa1		; ---------------------------------------
ConvDeg2Hexa1:					; Dixieme de degres en hexa dans A
jnc		ConvDeg2Hexa2
mov		DPTR,#ConvDeg2Hexa3
movc	A,@A+DPTR
ret
ConvDeg2Hexa2:					; Cas A>9
mov		A,#230
ret
ConvDeg2Hexa3:
db		0
db		26
db		51
db		77
db		102
db		128
db		154
db		179
db		205
db		230

ConvHexa2Deg:					; Conversion Hexa vers dixiemes de degres
cjne	A,#26,ConvHexaDeg1		; ---------------------------------------
ConvHexaDeg1:					; Octet hexa dans A en 256eme de degres
jnc		ConvHexaDegB1			; Sortie dans A en hexa de 0 a 9
mov		A,#0
ret
ConvHexaDegB1:
cjne	A,#51,ConvHexaDeg2
ConvHexaDeg2:
jnc		ConvHexaDegB2
mov		A,#1
ret
ConvHexaDegB2:
cjne	A,#77,ConvHexaDeg3
ConvHexaDeg3:
jnc		ConvHexaDegB3
mov		A,#2
ret
ConvHexaDegB3:
cjne	A,#102,ConvHexaDeg4
ConvHexaDeg4:
jnc		ConvHexaDegB4
mov		A,#3
ret
ConvHexaDegB4:
cjne	A,#128,ConvHexaDeg5
ConvHexaDeg5:
jnc		ConvHexaDegB5
mov		A,#4
ret
ConvHexaDegB5:
cjne	A,#154,ConvHexaDeg6
ConvHexaDeg6:
jnc		ConvHexaDegB6
mov		A,#5
ret
ConvHexaDegB6:
cjne	A,#179,ConvHexaDeg7
ConvHexaDeg7:
jnc		ConvHexaDegB7
mov		A,#6
ret
ConvHexaDegB7:
cjne	A,#205,ConvHexaDeg8
ConvHexaDeg8:
jnc		ConvHexaDegB8
mov		A,#7
ret
ConvHexaDegB8:
cjne	A,#230,ConvHexaDeg9
ConvHexaDeg9:
jnc		ConvHexaDegB9
mov		A,#8
ret
ConvHexaDegB9:
mov		A,#9
ret

AfficheHeure:					; Affichage de l'heure
mov		A,RHJ					; --------------------
rl		A						; Infos recuperees dans les registres
rl		A						; A= 4 * Jour
add		A,#LOW(Lun)
mov		DPL,A
mov		A,#0
addc	A,#HIGH(Lun)
mov		DPH,A
lcall	LcdWriteStringCode		; Affichage jour
mov		A,#32
lcall	LcdWriteChar
mov		A,RHH
lcall	LcdWriteByte			; Affichage heures
mov		A,#3Ah
lcall	LcdWriteChar
mov		A,RHM
lcall	LcdWriteByte			; Affichage minutes
mov		A,#3Ah
lcall	LcdWriteChar
mov		A,RHS
lcall	LcdWriteByte			; Affichage secondes
ret

AfficheDeca:					; Affichage du decalage
push	ACC						; ---------------------
mov		A,B						; Donnees dans {B,A} en binaire
mov		C,ACC.7					; Affichage sous la forme +2.2
jc		AfficheDeca1
mov		A,#'+'
lcall	LcdWriteChar
mov		A,B
add		A,#'0'
lcall	LcdWriteChar
mov		A,#'.'
lcall	LcdWriteChar
pop		ACC
lcall	ConvHexa2Deg
add		A,#'0'
lcall	LcdWriteChar
mov		A,#DFh
lcall	LcdWriteChar
ret
AfficheDeca1:					; Negatif
mov		A,#'-'
lcall	LcdWriteChar
pop		ACC
cpl		A						; Valeur absolue pour affichage
add		A,#1
push	ACC
mov		A,B
cpl		A
addc	A,#0
add		A,#'0'
lcall	LcdWriteChar
mov		A,#'.'
lcall	LcdWriteChar
pop		ACC
lcall	ConvHexa2Deg
add		A,#'0'
lcall	LcdWriteChar
mov		A,#DFh
lcall	LcdWriteChar
ret

PCF8583WriteProg:
;
; Titre		:	Ecriture du programme dans le PCF8583
;				-------------------------------------
;
; Entree(s)	:	Donnees dans RFirst a RFirst+Rnumber-1 en memoire interne
; Sortie(s) :	C=0 si echanges corrects
;				C=1 si pas d'acquitement I2C
;				PCF8583 donnees stockees a partir de 10h
; Utilise	:	?
; Pile		:	? avec l'appel
; Cycles	:	?
;
mov		DPTR,#PCF8583ProgEntete	; Ecriture de l'entete
mov		B,#10h
PCF8583WriteProgBoucle1:
clr		A
movc	A,@A+DPTR
jz		PCF8583WriteProgSuite1
lcall	PCF8583WriteData
jc		PCF8583WriteProgErreur
inc		DPTR
inc		B
ljmp	PCF8583WriteProgBoucle1
PCF8583WriteProgSuite1:			; Ecriture des donnees
mov		R0,#RFirst
mov		R1,#RNumber
PCF8583WriteProgBoucle2:
mov		A,@R0
lcall	PCF8583WriteData
jc		PCF8583WriteProgErreur
inc		R0
inc		B
djnz	R1,PCF8583WriteProgBoucle2
clr		C
ret
PCF8583WriteProgErreur:
setb	C
ret

PCF8583ReadProg:
;
; Titre		:	Lecture du programme dans le PCF8583
;				------------------------------------
;
; Entree(s)	:	PCF8583 donnees stockees a partir de 10h
; Sortie(s)	:	C=0 si echanges corrects et entete conforme
;				C=1 si pas d'acquitement I2C ou entete non conforme
;				Donnees lues dans RFirst a RFirst+Rnumber-1 en memoire interne
; Utilise	:	?
; Pile		:	? avec l'appel
; Cycles	:	?
;
mov		B,#10h					; Premiere adresse de stockage dans le PCF8583
mov		DPTR,#PCF8583ProgEntete	; Lecture et controle de l'entete
PCF8583ReadProgBoucle1:
clr		A
movc	A,@A+DPTR
jz		PCF8583ReadProgSuite1
mov		R2,A
lcall	PCF8583ReadData
jc		PCF8583ReadProgErreur	; Verif si lecture correcte
xrl		A,R2
jnz		PCF8583ReadProgErreur	; Erreur si l'entete ne correspond pas
inc		DPTR
inc		B
ljmp	PCF8583ReadProgBoucle1
PCF8583ReadProgSuite1:			; Lecture des donnees
mov		R0,#RFirst
mov		R1,#RNumber
PCF8583ReadProgBoucle2:
lcall	PCF8583ReadData
jc		PCF8583ReadProgErreur
mov		@R0,A
inc		R0
inc		B
djnz	R1,PCF8583ReadProgBoucle2
clr		C
ret
PCF8583ReadProgErreur:
setb	C
ret

INCLUDE	lib\libasc.asm
INCLUDE	lib\libcla2.asm
INCLUDE	lib\libcom1.asm
label	ComWriteChar, ComWriteChar7s
label	ComReadChar, ComReadChar7s
INCLUDE	lib\libcome.asm
INCLUDE	lib\libi2c.asm
INCLUDE	lib\libi2cus.asm
INCLUDE	lib\libjmp.asm
INCLUDE	lib\liblcd.asm
INCLUDE	lib\liblcdus.asm
INCLUDE	lib\libret.asm