// i2c.c

//-----------------------------------------------------------------------
//
//	Sous programmes de gestion du bus I2C
//	-------------------------------------
//
//	(C) 1996-2001 CHAMOUARD
//
//  (Libre de droits pour utilisation non commerciale 
//	et  vos propres risques)
//
//-----------------------------------------------------------------------

// Ces sous_programmes permettent d'interfacer un PC et un bus I2C a l'aide de
//   l'interface INTER_CE

// L'application doit :
//	- initialiser l'interface INTER_CE,
//	- initialiser l'interface I2C (i2c_init),
//	- lire ou ecrire dans l'interface i2c.

// Cette bibliotheque fournit :
//	- des lectures/ecritures bits a bit (i2c_putbit et i2c_getbit),
//	- des lectures/ecritures octet par octet (i2c_putbyte et i2c_getbyte),
//	- les ecriture des debut/fin de trame (i2c_start et i2c_stop).

#include "..\libelec\inter_ce.h"
#include "..\libelec\i2c.h"

// Constantes

#define 	AddWrite	0
#define 	AddRead		0
#define		SCL			8
#define		SDA			16
#define 	SDAin		2

// Definitions de sous-programmes internes

void	i2c_put(int);
int		i2c_get(void);

// Corps des fonctions

int i2c_init()
//
//	Initialisation de l'interface i2c
//
//	Retourne 0 si l'init est correcte
//
{
	ice_setport(2);
	if(ice_init()!=0)return(1);//Initialisation incorrecte de la carte inter_ce
	else  
	i2c_stop();
	return(0);
}

void i2c_start()
//
//	Ecriture d'un START sur le bus I2C
//
{
	i2c_put(SDA);		// Au cas ou
	i2c_put(SCL+SDA);	// Au cas ou
	i2c_put(SCL);		// 1->0 sur SDA
	i2c_put(0);			// 1->0 sur SCL
}

void i2c_stop()
//
//	Ecriture d'un stop sur le bus I2C
//
{
	i2c_put(0);			// Au cas ou
	i2c_put(SCL);		// 0->1 sur SCL
	i2c_put(SCL+SDA);	// 0->1 sur SDA
	i2c_put(SDA);		// 1->0 sur SCL
}

void i2c_putbit(int i)
//
//	Ecriture d'un bit sur le bus I2C
//
{
	if((i&1)==0)
	{
		i2c_put(0);
		i2c_put(SCL);
		i2c_put(0);
	}
	else
	{
		i2c_put(SDA);
		i2c_put(SCL+SDA);
		i2c_put(SDA);
	}
}

int	i2c_getbit()
//
//	Lecture d'un bit sur le bus I2C
//
{
	int i;
	i2c_put(SDA);
	i2c_put(SCL+SDA);
	i=i2c_get();
	i2c_put(SDA);
	return(i);
}

void i2c_putbyte(int data)
//
//	Ecriture d'un octet sur le bus I2C
//
{
	int i;
	for(i=0;i<8;++i)
	{
		i2c_putbit((data>>(7-i))&0x01);
	}
}

int	i2c_getbyte()
//
//	Lecture d'un octet sur le bus I2C
//
{
	int i,data;
	data=0;
	for(i=0;i<8;++i)
	{
		data=data*2+i2c_getbit();
	}
	return(data);
}

//	Corps des fonctions internes

void i2c_put(int i)
//
//	Positionnements de bits sur le bus I2C
//
{
	ice_write(AddWrite, i);
}

int i2c_get()
//
//	Lecture du bit de donnee sur le bus i2c
//
{
	int i;
	i=ice_read(AddRead);
	if(i & SDAin)return(1);
	return(0);
}
