//tsti2cpcf8583.c

//-----------------------------------------------------------------------
//																			
//	Programme du pcf8583 via bus I2C
//
//  (C) 2006 E.CHAMOUARD
//
//  (Libre de droits pour utilisation non commerciale 
//	et  vos propres risques)
//
//-----------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "..\libelec\inter_ce.h"
//#include "..\libelec\i2c.h"			// version avec interce
#include "..\libelec\i2c_ravar4.h"	// version avec ravar mod4
#include "..\libelec\i2cus.h"

int main()
{
	int i, add=0, res;
	int weekday, hour, minute, second;
	if(i2c_init()!=0)
	{
		printf("Erreur a l'initialisation I2C\n");
		printf("Hit any key ");
		while(!kbhit());
		return(0);
	}

	printf("Initialisation : %d\n", i2cus_pcf8583_init(add));

	printf("Ecriture : %d\n", i2cus_pcf8583_writeclock(add, 3, 13, 59, 30));

	do
	{
		if(i2cus_pcf8583_readclock(add, &weekday, &hour, &minute, &second)!=0)
		{
			printf("Erreur lors de la lecture\n");
			printf("Hit any key ");
			while(!kbhit());
			return(0);
		}
		printf("%1d %.2d:%.2d:%.2d\n", weekday, hour, minute, second);
	}
	while(!kbhit());
	getch();
	printf("Ecriture\n");
	for(i=16;i<256;++i)
	{
		if(i2cus_pcf8583_writeram(add, i, 255-i)!=0)
		{
			printf("\nErreur a l'ecriture\n");
			printf("Hit any key ");
			while(!kbhit());
			return(0);
		}
		printf("%.2x ", 255-i);
		if(i%16==15)printf("\n");
	}
	printf("\nLecture\n");
	for(i=16;i<256;++i)
	{
		if(i2cus_pcf8583_readram(add, i, &res)!=0)
		{
			printf("\nErreur a la  lecture\n");
			printf("Hit any key ");
			while(!kbhit());
			return(0);
		}
		printf("%.2x ", res);
		if(i%16==15)printf("\n");
	}
	printf("Hit any key ");
	while(!kbhit());
	return(0);
}